"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PickTimeline = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_super_select = require("../../../../timelines/components/timeline/search_super_select");
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/pick_timeline/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PickTimeline = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled = false,
  placeholder
}) => {
  const [timelineId, setTimelineId] = (0, _react.useState)(null);
  const [timelineTitle, setTimelineTitle] = (0, _react.useState)(null);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  (0, _react.useEffect)(() => {
    const {
      id,
      title
    } = field.value;
    if (timelineId !== id) {
      setTimelineId(id);
      setTimelineTitle(title);
    }
  }, [field.value, timelineId]);
  const handleOnTimelineChange = (0, _react.useCallback)((title, id) => {
    if (id === null) {
      field.setValue({
        id,
        title: null
      });
    } else if (timelineId !== id) {
      field.setValue({
        id,
        title
      });
    }
  }, [field, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_search_super_select.SearchTimelineSuperSelect, {
    isDisabled: isDisabled,
    hideUntitled: true,
    timelineId: timelineId,
    timelineTitle: timelineTitle,
    onTimelineChange: handleOnTimelineChange,
    placeholder: placeholder,
    "aria-label": field.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
};
exports.PickTimeline = PickTimeline;