"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../../common/components/empty_value");
var _health_truncate_text = require("../../../../common/components/health_truncate_text");
var _utils = require("./utils");
var _rule_monitoring = require("../../../../../common/api/detection_engine/rule_monitoring");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/rule_execution_status/rule_status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Shows rule execution status
 * @param status - rule execution status
 */
const RuleStatusBadgeComponent = ({
  status,
  message,
  showTooltip = true
}) => {
  const isFailedStatus = status === _rule_monitoring.RuleExecutionStatusEnum.failed || status === _rule_monitoring.RuleExecutionStatusEnum['partial failure'];
  const statusText = (0, _utils.getCapitalizedStatusText)(status);
  const statusTooltip = isFailedStatus && message ? message : statusText;
  const tooltipContent = showTooltip ? statusTooltip === null || statusTooltip === void 0 ? void 0 : statusTooltip.split('\n').map(line => /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 48
    }
  }, line)) : null;
  const statusColor = (0, _utils.getStatusColor)(status);
  return /*#__PURE__*/_react.default.createElement(_health_truncate_text.HealthTruncateText, {
    tooltipContent: tooltipContent,
    healthColor: statusColor,
    dataTestSubj: "ruleExecutionStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, statusText !== null && statusText !== void 0 ? statusText : (0, _empty_value.getEmptyTagValue)());
};
const RuleStatusBadge = exports.RuleStatusBadge = /*#__PURE__*/_react.default.memo(RuleStatusBadgeComponent);
RuleStatusBadge.displayName = 'RuleStatusBadge';