"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INSTALLED = exports.ALL = void 0;
exports.IntegrationViewFacets = IntegrationViewFacets;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _constants = require("../../../constants");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/tabs/integrations/components/view_facets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ALL = exports.ALL = _i18n.i18n.translate('xpack.securitySolution.configurations.integrations.allFacet', {
  defaultMessage: 'All integrations'
});
const INSTALLED = exports.INSTALLED = _i18n.i18n.translate('xpack.securitySolution.configurations.integrations.installedFacet', {
  defaultMessage: 'Installed integrations'
});
function IntegrationViewFacets({
  allCount,
  installedCount,
  selectedFacet
}) {
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFacetGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFacetButton, {
    css: (0, _react.css)`
          padding-inline: 0px;
        `,
    id: "integrationsAll",
    quantity: allCount,
    isSelected: selectedFacet === _constants.IntegrationsFacets.available,
    "data-test-subj": 'configurations.integrationsAll',
    onClick: () => navigateTo({
      deepLinkId: _deeplinksSecurity.SecurityPageName.configurationsIntegrations,
      path: 'browse'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, ALL), /*#__PURE__*/_react2.default.createElement(_eui.EuiFacetButton, {
    css: (0, _react.css)`
          padding-inline: 0px;
        `,
    id: "integrationsInstalled",
    quantity: installedCount,
    isSelected: selectedFacet === _constants.IntegrationsFacets.installed,
    "data-test-subj": 'configurations.integrationsInstalled',
    onClick: () => navigateTo({
      deepLinkId: _deeplinksSecurity.SecurityPageName.configurationsIntegrations,
      path: 'installed'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, INSTALLED));
}