"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyConfigurationsIntegrationsHome = exports.ConfigurationsIntegrationsHome = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../../../common/constants");
var _hooks = require("../../common/lib/search_ai_lake/hooks");
var _constants2 = require("../constants");
var _components = require("./integrations/components");
var _with_lazy_hook = require("../../common/components/with_lazy_hook");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/tabs/integrations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfigurationsIntegrationsHome = exports.ConfigurationsIntegrationsHome = /*#__PURE__*/_react.default.memo(({
  useAvailablePackages
}) => {
  const {
    filteredCards,
    isLoading,
    searchTerm,
    setSearchTerm
  } = useAvailablePackages({
    prereleaseIntegrationsEnabled: true
  });
  const allowedIntegrations = filteredCards.filter(card => _common.SEARCH_AI_LAKE_PACKAGES.includes(card.name));
  const {
    available,
    installed
  } = (0, _hooks.useEnhancedIntegrationCards)(allowedIntegrations);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_components.IntegrationsSkeleton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 25
      }
    }),
    loadedContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: `${_constants.CONFIGURATIONS_PATH}/${_constants2.ConfigurationTabs.integrations}/:view(${_constants2.IntegrationsFacets.available})`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_components.IntegrationsPage, {
      view: _constants2.IntegrationsFacets.available,
      availableIntegrations: available,
      installedIntegrations: installed,
      searchTerm: searchTerm,
      setSearchTerm: setSearchTerm,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: `${_constants.CONFIGURATIONS_PATH}/${_constants2.ConfigurationTabs.integrations}/:view(${_constants2.IntegrationsFacets.installed})`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_components.IntegrationsPage, {
      view: _constants2.IntegrationsFacets.installed,
      availableIntegrations: available,
      installedIntegrations: installed,
      searchTerm: searchTerm,
      setSearchTerm: setSearchTerm,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: `${_constants.CONFIGURATIONS_PATH}/${_constants2.ConfigurationTabs.integrations}`,
      render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: `${_constants.CONFIGURATIONS_PATH}/${_constants2.ConfigurationTabs.integrations}/${_constants2.IntegrationsFacets.available}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  });
});
ConfigurationsIntegrationsHome.displayName = 'ConfigurationsIntegrationsHome';
const LazyConfigurationsIntegrationsHome = exports.LazyConfigurationsIntegrationsHome = (0, _with_lazy_hook.withLazyHook)(ConfigurationsIntegrationsHome, () => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.AvailablePackagesHook()));
LazyConfigurationsIntegrationsHome.displayName = 'LazyConfigurationsIntegrationsHome';