"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onboardingHubTelemetryEvents = exports.onboardingHubStepSelectorClickedEvent = exports.onboardingHubStepOpenEvent = exports.onboardingHubStepLinkClickedEvent = exports.onboardingHubStepFinishedEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onboardingHubStepOpenEvent = exports.onboardingHubStepOpenEvent = {
  eventType: _types.OnboardingHubEventTypes.OnboardingHubStepOpen,
  schema: {
    stepId: {
      type: 'keyword',
      _meta: {
        description: 'Active step ID',
        optional: false
      }
    },
    trigger: {
      type: 'keyword',
      _meta: {
        description: 'The action type that triggers the event',
        optional: false
      }
    }
  }
};
const onboardingHubStepLinkClickedEvent = exports.onboardingHubStepLinkClickedEvent = {
  eventType: _types.OnboardingHubEventTypes.OnboardingHubStepLinkClicked,
  schema: {
    originStepId: {
      type: 'keyword',
      _meta: {
        description: 'Active step ID',
        optional: false
      }
    },
    stepLinkId: {
      type: 'keyword',
      _meta: {
        description: 'Clicked link',
        optional: false
      }
    }
  }
};
const onboardingHubStepFinishedEvent = exports.onboardingHubStepFinishedEvent = {
  eventType: _types.OnboardingHubEventTypes.OnboardingHubStepFinished,
  schema: {
    stepId: {
      type: 'keyword',
      _meta: {
        description: 'Finished step ID',
        optional: false
      }
    },
    stepLinkId: {
      type: 'keyword',
      _meta: {
        description: 'Finished step link ID',
        optional: true
      }
    },
    trigger: {
      type: 'keyword',
      _meta: {
        description: 'The action type that triggers the event',
        optional: false
      }
    }
  }
};
const onboardingHubStepSelectorClickedEvent = exports.onboardingHubStepSelectorClickedEvent = {
  eventType: _types.OnboardingHubEventTypes.OnboardingHubStepSelectorClicked,
  schema: {
    originStepId: {
      type: 'keyword',
      _meta: {
        description: 'Active step ID',
        optional: false
      }
    },
    selectorId: {
      type: 'keyword',
      _meta: {
        description: 'Clicked Selector ID',
        optional: false
      }
    }
  }
};
const onboardingHubTelemetryEvents = exports.onboardingHubTelemetryEvents = [onboardingHubStepOpenEvent, onboardingHubStepLinkClickedEvent, onboardingHubStepFinishedEvent, onboardingHubStepSelectorClickedEvent];