"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityIntegrationsGridTabs = exports.PackageListGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _integration_card_grid_tabs = require("../hooks/integration_card_grid_tabs.styles");
var _constants = require("../constants");
var _types = require("../types");
var _use_stored_state = require("../hooks/use_stored_state");
var _integration_context = require("../hooks/integration_context");
var _use_create_auto_import_card = require("../hooks/use_create_auto_import_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/integrations/components/security_integrations_grid_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyStateStyles = {
  paddingTop: '16px'
};
const PackageListGrid = exports.PackageListGrid = /*#__PURE__*/(0, _react.lazy)(async () => ({
  default: await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.PackageList()).then(pkg => pkg.PackageListGrid)
}));

// beware if local storage, need to add project id to the key
const SecurityIntegrationsGridTabs = exports.SecurityIntegrationsGridTabs = /*#__PURE__*/_react.default.memo(({
  isAgentRequired,
  activeIntegrationsCount,
  topCalloutRenderer: TopCallout,
  integrationList,
  availablePackages,
  packageListGridOptions,
  setSelectedTabId,
  selectedTab
}) => {
  var _selectedTab$height, _selectedTab$overflow, _selectedTab$category2;
  const {
    spaceId,
    telemetry: {
      reportLinkClick
    },
    integrationTabs
  } = (0, _integration_context.useIntegrationContext)();
  const scrollElement = (0, _react.useRef)(null);
  const createAutoImportCard = (0, _use_create_auto_import_card.useCreateAutoImportCard)();
  const integrationTabOptions = (0, _react.useMemo)(() => integrationTabs.map(tab => ({
    id: tab.id,
    label: tab.label,
    iconType: tab.iconType,
    'data-test-subj': `securitySolutionIntegrationsTab-${tab.id}`
  })), [integrationTabs]);
  const list = (0, _react.useMemo)(() => {
    if (!selectedTab.appendAutoImportCard) {
      return integrationList;
    }
    return [...integrationList, createAutoImportCard()];
  }, [integrationList, createAutoImportCard, selectedTab.appendAutoImportCard]);
  const [searchTermFromStorage, setSearchTermToStorage] = (0, _use_stored_state.useStoredIntegrationSearchTerm)(spaceId);
  const {
    isLoading,
    searchTerm,
    setCategory,
    setSearchTerm,
    setSelectedSubCategory
  } = availablePackages;
  const onTabChange = (0, _react.useCallback)(stringId => {
    var _scrollElement$curren, _scrollElement$curren2;
    const id = stringId;
    const trackId = `${_constants.TELEMETRY_INTEGRATION_TAB}_${id}`;
    (_scrollElement$curren = scrollElement.current) === null || _scrollElement$curren === void 0 ? void 0 : (_scrollElement$curren2 = _scrollElement$curren.scrollTo) === null || _scrollElement$curren2 === void 0 ? void 0 : _scrollElement$curren2.call(_scrollElement$curren, 0, 0);
    setSelectedTabId === null || setSelectedTabId === void 0 ? void 0 : setSelectedTabId(id);
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(trackId);
  }, [setSelectedTabId, reportLinkClick]);
  const buttonGroupStyles = (0, _integration_card_grid_tabs.useIntegrationCardGridTabsStyles)();
  const onSearchTermChanged = (0, _react.useCallback)(searchQuery => {
    setSearchTerm(searchQuery);
    // Search term is preserved across VISIBLE tabs
    // As we want user to be able to see the same search results when coming back from Fleet
    if (selectedTab.showSearchTools) {
      setSearchTermToStorage(searchQuery);
    }
  }, [selectedTab.showSearchTools, setSearchTerm, setSearchTermToStorage]);
  (0, _react.useEffect)(() => {
    var _selectedTab$category;
    setCategory((_selectedTab$category = selectedTab.category) !== null && _selectedTab$category !== void 0 ? _selectedTab$category : '');
    setSelectedSubCategory(selectedTab.subCategory);
    if (!selectedTab.showSearchTools) {
      // If search box are not shown, clear the search term to avoid unexpected filtering
      onSearchTermChanged('');
    }
    if (selectedTab.showSearchTools && searchTermFromStorage && selectedTab.id !== _types.IntegrationTabId.recommended) {
      setSearchTerm(searchTermFromStorage);
    }
  }, [onSearchTermChanged, searchTermFromStorage, selectedTab.category, selectedTab.showSearchTools, selectedTab.subCategory, setCategory, setSearchTerm, setSelectedSubCategory, selectedTab.id]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      "data-test-subj": "loadingPackages",
      isLoading: true,
      lines: _constants.LOADING_SKELETON_TEXT_LINES,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "step-paragraph",
    gutterSize: selectedTab.showSearchTools ? 'm' : 'none',
    css: (0, _react2.css)`
          height: ${(_selectedTab$height = selectedTab.height) !== null && _selectedTab$height !== void 0 ? _selectedTab$height : _constants.DEFAULT_INTEGRATION_CARD_CONTENT_HEIGHT};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, integrationTabOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    css: buttonGroupStyles,
    buttonSize: "compressed",
    color: "primary",
    idSelected: selectedTab.id,
    isFullWidth: true,
    legend: "Categories",
    onChange: onTabChange,
    options: integrationTabOptions,
    type: "single",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            overflow-y: ${(_selectedTab$overflow = selectedTab.overflow) !== null && _selectedTab$overflow !== void 0 ? _selectedTab$overflow : 'auto'};
          `,
    grow: 1,
    id: _constants.SCROLL_ELEMENT_ID,
    ref: scrollElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      isLoading: true,
      lines: _constants.LOADING_SKELETON_TEXT_LINES,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(PackageListGrid, {
    callout: TopCallout ? /*#__PURE__*/_react.default.createElement(TopCallout, {
      isAgentRequired: isAgentRequired,
      activeIntegrationsCount: activeIntegrationsCount,
      selectedTabId: selectedTab.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 19
      }
    }) : null,
    calloutTopSpacerSize: "m",
    categories: _constants.SEARCH_FILTER_CATEGORIES // We do not want to show categories and subcategories as the search bar filter
    ,
    emptyStateStyles: emptyStateStyles,
    list: list,
    scrollElementId: _constants.SCROLL_ELEMENT_ID,
    searchTerm: searchTerm,
    selectedCategory: (_selectedTab$category2 = selectedTab.category) !== null && _selectedTab$category2 !== void 0 ? _selectedTab$category2 : '',
    selectedSubCategory: selectedTab.subCategory,
    setCategory: setCategory,
    setSearchTerm: onSearchTermChanged,
    setUrlandPushHistory: _lodash.noop,
    setUrlandReplaceHistory: _lodash.noop,
    showCardLabels: packageListGridOptions === null || packageListGridOptions === void 0 ? void 0 : packageListGridOptions.showCardLabels,
    showControls: false,
    showSearchTools: selectedTab.showSearchTools,
    sortByFeaturedIntegrations: selectedTab.sortByFeaturedIntegrations,
    spacer: TopCallout ? true : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }))));
});
SecurityIntegrationsGridTabs.displayName = 'IntegrationsCardGridTabsComponent';