"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToAlertsPageWithFilters = void 0;
var _rison = require("@kbn/rison");
var _constants = require("../../../common/constants");
var _format_page_filter_search_param = require("../../../common/utils/format_page_filter_search_param");
var _kibana = require("../lib/kibana");
var _use_url_state = require("./use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToAlertsPageWithFilters = () => {
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  return (filterItems,
  /**
   * If true, the alerts page will be opened in a new tab
   */
  openInNewTab = false, timerange) => {
    const urlFilterParams = (0, _rison.encode)((0, _format_page_filter_search_param.formatPageFilterSearchParam)(Array.isArray(filterItems) ? filterItems : [filterItems]));
    const timerangePath = timerange ? `&timerange=${timerange}` : '';
    navigateTo({
      deepLinkId: _constants.SecurityPageName.alerts,
      path: `?${_use_url_state.URL_PARAM_KEY.pageFilter}=${urlFilterParams}${timerangePath}`,
      openInNewTab
    });
  };
};
exports.useNavigateToAlertsPageWithFilters = useNavigateToAlertsPageWithFilters;