"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToNewCase = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../common");
var _kibana = require("../../lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToNewCase = ({
  onClick,
  timeRange,
  lensAttributes,
  lensMetadata
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_common2.APP_ID]);
  const attachments = (0, _react.useMemo)(() => {
    return [{
      persistableStateAttachmentState: {
        attributes: lensAttributes,
        timeRange,
        metadata: lensMetadata
      },
      persistableStateAttachmentTypeId: _common.LENS_ATTACHMENT_TYPE,
      type: _common.AttachmentType.persistableState
    }];
  }, [lensAttributes, lensMetadata, timeRange]);
  const {
    open: openCreateCaseFlyout
  } = cases.hooks.useCasesAddToNewCaseFlyout({
    toastContent: _translations.ADD_TO_CASE_SUCCESS
  });
  const onAddToNewCaseClicked = (0, _react.useCallback)(() => {
    if (onClick) {
      onClick();
    }
    openCreateCaseFlyout({
      attachments
    });
  }, [attachments, openCreateCaseFlyout, onClick]);
  return {
    onAddToNewCaseClicked,
    disabled: lensAttributes == null || timeRange == null || !userCasesPermissions.createComment || !userCasesPermissions.read
  };
};
exports.useAddToNewCase = useAddToNewCase;