"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersAvatarsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _translations = require("./translations");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/user_profiles/users_avatars_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays users avatars
 */
const UsersAvatarsPanel = exports.UsersAvatarsPanel = /*#__PURE__*/(0, _react.memo)(({
  userProfiles,
  maxVisibleAvatars
}) => {
  if (maxVisibleAvatars && userProfiles.length > maxVisibleAvatars) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: userProfiles.map(user => {
        var _user$user$email;
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 13
          }
        }, user ? (_user$user$email = user.user.email) !== null && _user$user$email !== void 0 ? _user$user$email : user.user.username : _translations.UNKNOWN_USER_PROFILE_NAME);
      }),
      repositionOnScroll: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": _test_ids.USERS_AVATARS_COUNT_BADGE_TEST_ID,
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, userProfiles.length));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.USERS_AVATARS_PANEL_TEST_ID,
    alignItems: "center",
    direction: "row",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, userProfiles.map((user, index) => {
    var _user$user$username;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      "data-test-subj": (0, _test_ids.USER_AVATAR_ITEM_TEST_ID)((_user$user$username = user === null || user === void 0 ? void 0 : user.user.username) !== null && _user$user$username !== void 0 ? _user$user$username : `Unknown-${index}`),
      user: user === null || user === void 0 ? void 0 : user.user,
      avatar: user === null || user === void 0 ? void 0 : user.data.avatar,
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }));
  }));
});
UsersAvatarsPanel.displayName = 'UsersAvatarsPanel';