"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopN = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _events_by_dataset = require("../../../overview/components/events_by_dataset");
var _signals_by_category = require("../../../overview/components/signals_by_category");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/top_n/top_n.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    topNContainer: (0, _react2.css)`
      min-width: 600px;
    `,
    closeButton: (0, _react2.css)`
      position: absolute;
      right: 4px;
      top: 4px;
    `,
    viewSelect: (0, _react2.css)`
      width: 170px;
    `,
    topNContent: (0, _react2.css)`
      margin-top: 4px;
      margin-right: ${euiTheme.size.xs};

      .euiPanel {
        border: none;
      }
    `
  };
};
const TopNComponent = ({
  filterQuery,
  defaultView,
  deleteQuery,
  filters,
  field,
  from,
  dataView,
  dataViewSpec,
  options,
  paddingSize,
  query,
  setAbsoluteRangeDatePickerTarget,
  scopeId,
  to,
  toggleTopN,
  applyGlobalQueriesAndFilters
}) => {
  const styles = useStyles();
  const [view, setView] = (0, _react.useState)(defaultView);
  const onViewSelected = (0, _react.useCallback)(value => setView(value), [setView]);
  const sourcererScopeId = (0, _helpers.getSourcererScopeName)({
    scopeId,
    view
  });
  (0, _react.useEffect)(() => {
    setView(defaultView);
  }, [defaultView]);
  const headerChildren = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    css: styles.viewSelect,
    "data-test-subj": "view-select",
    disabled: options.length === 1,
    onChange: onViewSelected,
    options: options,
    valueOfSelected: view,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), [onViewSelected, options, styles.viewSelect, view]);

  // alert workflow statuses (e.g. open | closed) and other alert-specific
  // filters must be ignored when viewing raw alerts
  const applicableFilters = (0, _react.useMemo)(() => (0, _helpers.removeIgnoredAlertFilters)({
    filters,
    tableId: scopeId,
    view
  }), [filters, scopeId, view]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.topNContainer,
    "data-test-subj": "topN-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.topNContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, view === 'raw' || view === 'all' ? /*#__PURE__*/_react.default.createElement(_events_by_dataset.EventsByDataset, {
    filterQuery: filterQuery,
    deleteQuery: deleteQuery,
    filters: applicableFilters,
    from: from,
    headerChildren: headerChildren,
    dataView: dataView,
    dataViewSpec: dataViewSpec,
    onlyField: field,
    paddingSize: paddingSize,
    query: query,
    queryType: "topN",
    showSpacer: false,
    sourcererScopeId: sourcererScopeId,
    to: to,
    hideQueryToggle: true,
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_signals_by_category.SignalsByCategory, {
    filters: applicableFilters,
    headerChildren: headerChildren,
    onlyField: field,
    paddingSize: paddingSize,
    setAbsoluteRangeDatePickerTarget: setAbsoluteRangeDatePickerTarget,
    hideQueryToggle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: styles.closeButton,
    "aria-label": i18n.CLOSE,
    "data-test-subj": "close",
    iconType: "cross",
    onClick: toggleTopN,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }));
};
TopNComponent.displayName = 'TopNComponent';
const TopN = exports.TopN = /*#__PURE__*/_react.default.memo(TopNComponent);