"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKubernetesUrl = exports.getKubernetesDetailsUrl = void 0;
var _constants = require("../../../../common/constants");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKubernetesUrl = search => `${_constants.KUBERNETES_PATH}${(0, _helpers.appendSearch)(search)}`;
exports.getKubernetesUrl = getKubernetesUrl;
const getKubernetesDetailsUrl = (detailName, search) => `/${encodeURIComponent(detailName)}${(0, _helpers.appendSearch)(search)}`;
exports.getKubernetesDetailsUrl = getKubernetesDetailsUrl;