"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTabsOnHostsUrl = exports.getTabsOnHostDetailsUrl = exports.getHostsUrl = exports.getHostDetailsUrl = void 0;
var _constants = require("../../../../common/constants");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostsUrl = search => `${_constants.HOSTS_PATH}${(0, _helpers.appendSearch)(search)}`;
exports.getHostsUrl = getHostsUrl;
const getTabsOnHostsUrl = (tabName, search) => `/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getTabsOnHostsUrl = getTabsOnHostsUrl;
const getHostDetailsUrl = (detailName, search) => `/name/${encodeURIComponent(detailName)}${(0, _helpers.appendSearch)(search)}`;
exports.getHostDetailsUrl = getHostDetailsUrl;
const getTabsOnHostDetailsUrl = (detailName, tabName, search) => `/name/${encodeURIComponent(detailName)}/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getTabsOnHostDetailsUrl = getTabsOnHostDetailsUrl;