"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesUrl = exports.getRuleDetailsUrl = exports.getRuleDetailsTabUrl = exports.getEditRuleUrl = exports.getDetectionEngineUrl = void 0;
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDetectionEngineUrl = search => `${(0, _helpers.appendSearch)(search)}`;
exports.getDetectionEngineUrl = getDetectionEngineUrl;
const getRulesUrl = search => `${(0, _helpers.appendSearch)(search)}`;
exports.getRulesUrl = getRulesUrl;
const getRuleDetailsUrl = (detailName, search) => `/id/${encodeURIComponent(detailName)}${(0, _helpers.appendSearch)(search)}`;
exports.getRuleDetailsUrl = getRuleDetailsUrl;
const getRuleDetailsTabUrl = (detailName, tabName, search) => `/id/${encodeURIComponent(detailName)}/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getRuleDetailsTabUrl = getRuleDetailsTabUrl;
const getEditRuleUrl = (detailName, search) => `/id/${encodeURIComponent(detailName)}/edit${(0, _helpers.appendSearch)(search)}`;
exports.getEditRuleUrl = getEditRuleUrl;