"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertBulkActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/events_viewer/use_alert_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatefulAlertBulkActions = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../toolbar/bulk_actions/alert_bulk_actions'))));
const useAlertBulkActions = ({
  tableId,
  data,
  totalItems,
  hasAlertsCrud,
  showCheckboxes,
  filterStatus,
  filterQuery,
  bulkActions,
  selectedCount
}) => {
  const showBulkActions = (0, _react.useMemo)(() => {
    var _ref, _bulkActions$customBu;
    if (!hasAlertsCrud) {
      return false;
    }
    if (selectedCount === 0 || !showCheckboxes) {
      return false;
    }
    if (typeof bulkActions === 'boolean') {
      return bulkActions;
    }
    return (_ref = (bulkActions === null || bulkActions === void 0 ? void 0 : (_bulkActions$customBu = bulkActions.customBulkActions) === null || _bulkActions$customBu === void 0 ? void 0 : _bulkActions$customBu.length) || (bulkActions === null || bulkActions === void 0 ? void 0 : bulkActions.alertStatusActions)) !== null && _ref !== void 0 ? _ref : true;
  }, [hasAlertsCrud, selectedCount, showCheckboxes, bulkActions]);
  const onAlertStatusActionSuccess = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true) {
      return bulkActions.onAlertStatusActionSuccess;
    }
  }, [bulkActions]);
  const onAlertStatusActionFailure = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true) {
      return bulkActions.onAlertStatusActionFailure;
    }
  }, [bulkActions]);
  const showAlertStatusActions = (0, _react.useMemo)(() => {
    var _ref2;
    if (!hasAlertsCrud) {
      return false;
    }
    if (typeof bulkActions === 'boolean') {
      return bulkActions;
    }
    return (_ref2 = bulkActions && bulkActions.alertStatusActions) !== null && _ref2 !== void 0 ? _ref2 : true;
  }, [bulkActions, hasAlertsCrud]);
  const additionalBulkActions = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true && bulkActions.customBulkActions !== undefined) {
      return bulkActions.customBulkActions.map(action => {
        return {
          ...action,
          onClick: eventIds => {
            const items = data.filter(item => {
              return eventIds.find(event => item._id === event);
            });
            action.onClick(items);
          }
        };
      });
    }
  }, [bulkActions, data]);
  const alertBulkActions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showBulkActions && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 31
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StatefulAlertBulkActions, {
    showAlertStatusActions: showAlertStatusActions,
    "data-test-subj": "bulk-actions",
    id: tableId,
    totalItems: totalItems,
    filterStatus: filterStatus,
    query: filterQuery,
    onActionSuccess: onAlertStatusActionSuccess,
    onActionFailure: onAlertStatusActionFailure,
    customBulkActions: additionalBulkActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }))), [additionalBulkActions, filterQuery, filterStatus, onAlertStatusActionFailure, onAlertStatusActionSuccess, showAlertStatusActions, showBulkActions, tableId, totalItems]);
  return alertBulkActions;
};
exports.useAlertBulkActions = useAlertBulkActions;