"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyle = exports.disableHoverActions = exports.ProviderContentWrapper = exports.DraggableWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../timelines/components/row_renderers_browser/constants");
var _truncatable_text = require("../truncatable_text");
var _cell_actions_wrapper = require("./cell_actions_wrapper");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/drag_and_drop/draggable_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProviderContentWrapper = exports.ProviderContentWrapper = _styledComponents.default.span`
  > span.euiToolTipAnchor {
    display: block; /* allow EuiTooltip content to be truncatable */
  }

  > span.euiToolTipAnchor.eui-textTruncate {
    display: inline-block; /* do not override display when a tooltip is truncated via eui-textTruncate */
  }
`;
const disableHoverActions = timelineId => [_securitysolutionDataTable.TableId.rulePreview, _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID].includes(timelineId !== null && timelineId !== void 0 ? timelineId : '');

/**
 * Wraps a draggable component to handle registration / unregistration of the
 * data provider associated with the item being dropped
 */
exports.disableHoverActions = disableHoverActions;
const getStyle = (style, snapshot) => {
  if (!snapshot.isDropAnimating) {
    return style;
  }
  return {
    ...style,
    transitionDuration: '0.00000001s' // cannot be 0, but can be a very short duration
  };
};
exports.getStyle = getStyle;
const DraggableWrapper = exports.DraggableWrapper = /*#__PURE__*/_react.default.memo(({
  dataProvider,
  render,
  scopeId,
  truncate,
  hideTopN
}) => {
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: -1,
    "data-provider-id": (0, _helpers.getDraggableId)(dataProvider.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "render-truncatable-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, render(dataProvider, null, {
    isDragging: false,
    isDropAnimating: false,
    isClone: false,
    dropAnimation: null,
    draggingOver: null,
    combineWith: null,
    combineTargetFor: null,
    mode: null
  })) : /*#__PURE__*/_react.default.createElement(ProviderContentWrapper, {
    "data-test-subj": `render-content-${dataProvider.queryMatch.field}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, render(dataProvider, null, {
    isDragging: false,
    isDropAnimating: false,
    isClone: false,
    dropAnimation: null,
    draggingOver: null,
    combineWith: null,
    combineTargetFor: null,
    mode: null
  }))), [dataProvider, render, truncate]);
  if (disableHoverActions(scopeId)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
  }
  return /*#__PURE__*/_react.default.createElement(_cell_actions_wrapper.CellActionsWrapper, {
    dataProvider: dataProvider,
    scopeId: scopeId,
    hideTopN: hideTopN,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, content);
});
DraggableWrapper.displayName = 'DraggableWrapper';