"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsTabCsp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _misconfiguration_findings_details_table = require("./misconfiguration_findings_details_table");
var _vulnerabilities_findings_details_table = require("./vulnerabilities_findings_details_table");
var _alerts_findings_details_table = require("./alerts_findings_details_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/csp_details/insights_tab_csp.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Insights view displayed in the document details expandable flyout left section
 */

// Type guard to check if the panel is a CspFlyoutPanelProps
function isCspFlyoutPanelProps(panelLeft) {
  var _panelLeft$params, _panelLeft$params2, _panelLeft$params3;
  return !!(panelLeft !== null && panelLeft !== void 0 && (_panelLeft$params = panelLeft.params) !== null && _panelLeft$params !== void 0 && _panelLeft$params.hasMisconfigurationFindings) || !!(panelLeft !== null && panelLeft !== void 0 && (_panelLeft$params2 = panelLeft.params) !== null && _panelLeft$params2 !== void 0 && _panelLeft$params2.hasVulnerabilitiesFindings) || !!(panelLeft !== null && panelLeft !== void 0 && (_panelLeft$params3 = panelLeft.params) !== null && _panelLeft$params3 !== void 0 && _panelLeft$params3.hasNonClosedAlerts);
}
const InsightsTabCsp = exports.InsightsTabCsp = /*#__PURE__*/(0, _react.memo)(({
  value,
  field,
  scopeId
}) => {
  var _panels$left4, _panels$left4$params, _panels$left5, _panels$left5$params, _panels$left6, _panels$left6$params;
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  let hasMisconfigurationFindings = false;
  let hasVulnerabilitiesFindings = false;
  let hasNonClosedAlerts = false;
  let subTab;

  // Check if panels.left is of type CspFlyoutPanelProps and extract values
  if (isCspFlyoutPanelProps(panels.left)) {
    var _panels$left$params$p;
    hasMisconfigurationFindings = panels.left.params.hasMisconfigurationFindings;
    hasVulnerabilitiesFindings = panels.left.params.hasVulnerabilitiesFindings;
    hasNonClosedAlerts = panels.left.params.hasNonClosedAlerts;
    subTab = (_panels$left$params$p = panels.left.params.path) === null || _panels$left$params$p === void 0 ? void 0 : _panels$left$params$p.subTab;
  }
  const getDefaultTab = () => {
    if (subTab) {
      return subTab;
    }
    return hasMisconfigurationFindings ? _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS : hasVulnerabilitiesFindings ? _left_panel_header.CspInsightLeftPanelSubTab.VULNERABILITIES : hasNonClosedAlerts ? _left_panel_header.CspInsightLeftPanelSubTab.ALERTS : '';
  };
  const [activeInsightsId, setActiveInsightsId] = (0, _react.useState)(getDefaultTab());
  (0, _react.useEffect)(() => {
    if (subTab) {
      setActiveInsightsId(subTab);
    }
  }, [subTab]);
  const insightsButtons = (0, _react.useMemo)(() => {
    var _panels$left, _panels$left$params, _panels$left2, _panels$left2$params, _panels$left3, _panels$left3$params;
    const buttons = [];
    if ((_panels$left = panels.left) !== null && _panels$left !== void 0 && (_panels$left$params = _panels$left.params) !== null && _panels$left$params !== void 0 && _panels$left$params.hasNonClosedAlerts) {
      buttons.push({
        id: _left_panel_header.CspInsightLeftPanelSubTab.ALERTS,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.left.insights.alertsButtonLabel",
          defaultMessage: "Alerts",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 13
          }
        }),
        'data-test-subj': 'alertsTabDataTestId'
      });
    }
    if ((_panels$left2 = panels.left) !== null && _panels$left2 !== void 0 && (_panels$left2$params = _panels$left2.params) !== null && _panels$left2$params !== void 0 && _panels$left2$params.hasMisconfigurationFindings) {
      buttons.push({
        id: _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.left.insights.misconfigurationButtonLabel",
          defaultMessage: "Misconfiguration",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 13
          }
        }),
        'data-test-subj': 'misconfigurationTabDataTestId'
      });
    }
    if ((_panels$left3 = panels.left) !== null && _panels$left3 !== void 0 && (_panels$left3$params = _panels$left3.params) !== null && _panels$left3$params !== void 0 && _panels$left3$params.hasVulnerabilitiesFindings) {
      buttons.push({
        id: _left_panel_header.CspInsightLeftPanelSubTab.VULNERABILITIES,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.left.insights.vulnerabilitiesButtonLabel",
          defaultMessage: "Vulnerabilities",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 13
          }
        }),
        'data-test-subj': 'vulnerabilitiesTabDataTestId'
      });
    }
    return buttons;
  }, [(_panels$left4 = panels.left) === null || _panels$left4 === void 0 ? void 0 : (_panels$left4$params = _panels$left4.params) === null || _panels$left4$params === void 0 ? void 0 : _panels$left4$params.hasMisconfigurationFindings, (_panels$left5 = panels.left) === null || _panels$left5 === void 0 ? void 0 : (_panels$left5$params = _panels$left5.params) === null || _panels$left5$params === void 0 ? void 0 : _panels$left5$params.hasNonClosedAlerts, (_panels$left6 = panels.left) === null || _panels$left6 === void 0 ? void 0 : (_panels$left6$params = _panels$left6.params) === null || _panels$left6$params === void 0 ? void 0 : _panels$left6$params.hasVulnerabilitiesFindings]);
  const onTabChange = id => {
    setActiveInsightsId(id);
  };
  if (insightsButtons.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.optionsButtonGroups', {
      defaultMessage: 'Insights options'
    }),
    options: insightsButtons,
    idSelected: activeInsightsId,
    onChange: onTabChange,
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": 'insightButtonGroupsTestId',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }), activeInsightsId === _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS ? /*#__PURE__*/_react.default.createElement(_misconfiguration_findings_details_table.MisconfigurationFindingsDetailsTable, {
    field: field,
    value: value,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }) : activeInsightsId === _left_panel_header.CspInsightLeftPanelSubTab.VULNERABILITIES ? /*#__PURE__*/_react.default.createElement(_vulnerabilities_findings_details_table.VulnerabilitiesFindingsDetailsTable, {
    value: value,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_alerts_findings_details_table.AlertsDetailsTable, {
    field: field,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }));
});
InsightsTabCsp.displayName = 'InsightsTab';