"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetAttackDiscoveryGenerations = exports.useGetAttackDiscoveryGenerations = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _use_kibana_feature_flags = require("../use_kibana_feature_flags");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAttackDiscoveryGenerations = ({
  end,
  http,
  isAssistantEnabled,
  size,
  start,
  refetchOnWindowFocus = false
}) => {
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortController = (0, _react.useRef)(new AbortController());
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController(); // LOCAL MUTATION
  }, []);
  const queryFn = (0, _react.useCallback)(async () => {
    const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS : _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_INTERNAL;
    const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
    return http.fetch(route, {
      method: 'GET',
      version,
      query: {
        end,
        size,
        start
      },
      signal: abortController.current.signal
    });
  }, [attackDiscoveryPublicApiEnabled, end, http, size, start]);
  const routeKey = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS : _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_INTERNAL;
  const {
    data,
    error,
    isLoading,
    refetch,
    status
  } = (0, _reactQuery.useQuery)(['GET', routeKey, end, isAssistantEnabled, size, start], queryFn, {
    enabled: isAssistantEnabled,
    onError: e => {
      addError(e.body && e.body.message ? new Error(e.body.message) : e, {
        title: i18n.ERROR_RETRIEVING_ATTACK_DISCOVERY_GENERATIONS
      });
    },
    refetchOnWindowFocus
  });
  return {
    cancelRequest,
    data,
    error,
    isLoading,
    refetch,
    status
  };
};

/**
 * We use this hook to invalidate the attack discovery generations cache.
 *
 * @returns A attack discovery schedule cache invalidation callback
 */
exports.useGetAttackDiscoveryGenerations = useGetAttackDiscoveryGenerations;
const useInvalidateGetAttackDiscoveryGenerations = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  return (0, _react.useCallback)(() => {
    const routeKey = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS : _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_INTERNAL;
    queryClient.invalidateQueries(['GET', routeKey], {
      refetchType: 'all'
    });
  }, [queryClient, attackDiscoveryPublicApiEnabled]);
};
exports.useInvalidateGetAttackDiscoveryGenerations = useInvalidateGetAttackDiscoveryGenerations;