"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleDefinition = void 0;
exports.getQueryLanguageLabel = getQueryLanguageLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _filters = require("./filters");
var _common_field = require("./common_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/details_flyout/definition/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS = ['30%', '70%'];
function getQueryLanguageLabel(language) {
  switch (language) {
    case 'kuery':
      return i18n.KUERY_LANGUAGE_LABEL;
    case 'lucene':
      return i18n.LUCENE_LANGUAGE_LABEL;
    default:
      return language;
  }
}
const ScheduleDefinition = exports.ScheduleDefinition = /*#__PURE__*/_react.default.memo(({
  schedule
}) => {
  const definitionSectionListItems = (0, _react.useMemo)(() => {
    var _schedule$params$filt, _schedule$params$quer;
    const items = [];
    if ((_schedule$params$filt = schedule.params.filters) !== null && _schedule$params$filt !== void 0 && _schedule$params$filt.length) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "filtersTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 42,
            columnNumber: 16
          }
        }, i18n.FILTERS_LABEL),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "filtersValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_filters.Filters, {
          filters: schedule.params.filters,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 13
          }
        }))
      });
    }
    if ((_schedule$params$quer = schedule.params.query) !== null && _schedule$params$quer !== void 0 && _schedule$params$quer.query.length) {
      const query = schedule.params.query;
      items.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 55,
            columnNumber: 18
          }
        }, i18n.QUERY_LABEL),
        description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
          value: typeof query.query === 'string' ? query.query : JSON.stringify(query.query),
          "data-test-subj": "queryValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 57,
            columnNumber: 13
          }
        })
      }, {
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryLanguageTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 18
          }
        }, i18n.QUERY_LANGUAGE_LABEL),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "queryLanguageValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 13
          }
        }, getQueryLanguageLabel(query.language))
      });
    }
    items.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "scheduleIntervalTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 14
        }
      }, i18n.SCHEDULE_INTERVAL_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
        value: (0, _common.formatDuration)(schedule.schedule.interval, true),
        "data-test-subj": "scheduleIntervalValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      })
    });
    items.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "connectorTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 14
        }
      }, i18n.CONNECTOR_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_common_field.CommonField, {
        value: schedule.params.apiConfig.name,
        "data-test-subj": "connectorValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      })
    });
    return items;
  }, [schedule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "definitionTitle",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, i18n.DEFINITION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "scheduleDetailsDefinition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: 'column',
    rowGutterSize: 'm',
    listItems: definitionSectionListItems,
    columnWidths: DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
    "data-test-subj": "listItemColumnScheduleDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
});
ScheduleDefinition.displayName = 'ScheduleDefinition';