"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAttackDiscoverySchedule = exports.getAttackDiscoverySchedule = exports.findAttackDiscoverySchedule = exports.fetchRuleTypes = exports.enableAttackDiscoverySchedule = exports.disableAttackDiscoverySchedule = exports.deleteAttackDiscoverySchedule = exports.createAttackDiscoverySchedule = exports.ALERTING_RULE_TYPES_URL = void 0;
var _shared = require("@kbn/openapi-common/shared");
var _common = require("@kbn/alerting-plugin/common");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTING_RULE_TYPES_URL = exports.ALERTING_RULE_TYPES_URL = `${_common.BASE_ALERTING_API_PATH}/rule_types`;
/** Creates a new attack discovery schedule with the provided attributes. */
const createAttackDiscoverySchedule = async ({
  body,
  signal,
  attackDiscoveryPublicApiEnabled
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;

  // Transform body format for public API (snake_case) vs internal API (camelCase)
  const requestBody = attackDiscoveryPublicApiEnabled ? (0, _elasticAssistantCommon.transformAttackDiscoveryScheduleCreatePropsToApi)(body) : body;
  return _kibana.KibanaServices.get().http.post(route, {
    body: JSON.stringify(requestBody),
    version,
    signal
  });
};
exports.createAttackDiscoverySchedule = createAttackDiscoverySchedule;
/** Retrieves the attack discovery schedule. */
const getAttackDiscoverySchedule = async ({
  id,
  signal,
  attackDiscoveryPublicApiEnabled
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(route, {
    id
  }), {
    version,
    signal
  });
};
exports.getAttackDiscoverySchedule = getAttackDiscoverySchedule;
/** Updates the attack discovery schedule. */
const updateAttackDiscoverySchedule = async ({
  attackDiscoveryPublicApiEnabled,
  id,
  body,
  signal
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;

  // Transform body format for public API (snake_case) vs internal API (camelCase)
  const requestBody = attackDiscoveryPublicApiEnabled ? (0, _elasticAssistantCommon.transformAttackDiscoveryScheduleUpdatePropsToApi)(body) : body;
  return _kibana.KibanaServices.get().http.put((0, _shared.replaceParams)(route, {
    id
  }), {
    body: JSON.stringify(requestBody),
    version,
    signal
  });
};
exports.updateAttackDiscoverySchedule = updateAttackDiscoverySchedule;
/** Deletes the attack discovery schedule. */
const deleteAttackDiscoverySchedule = async ({
  id,
  signal,
  attackDiscoveryPublicApiEnabled
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  return _kibana.KibanaServices.get().http.delete((0, _shared.replaceParams)(route, {
    id
  }), {
    version,
    signal
  });
};
exports.deleteAttackDiscoverySchedule = deleteAttackDiscoverySchedule;
/** Enables the attack discovery schedule. */
const enableAttackDiscoverySchedule = async ({
  id,
  signal,
  attackDiscoveryPublicApiEnabled
}) => {
  const isPublic = !!attackDiscoveryPublicApiEnabled;
  const route = isPublic ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID_ENABLE : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_ENABLE;
  const version = isPublic ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(route, {
    id
  }), {
    version,
    signal
  });
};
exports.enableAttackDiscoverySchedule = enableAttackDiscoverySchedule;
/** Disables the attack discovery schedule. */
const disableAttackDiscoverySchedule = async ({
  attackDiscoveryPublicApiEnabled,
  id,
  signal
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID_DISABLE : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_DISABLE;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(route, {
    id
  }), {
    version,
    signal
  });
};
exports.disableAttackDiscoverySchedule = disableAttackDiscoverySchedule;
/** Retrieves attack discovery schedules. */
const findAttackDiscoverySchedule = async ({
  attackDiscoveryPublicApiEnabled,
  page,
  perPage,
  sortField,
  sortDirection,
  signal
}) => {
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_FIND : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_FIND;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  const query = attackDiscoveryPublicApiEnabled ?
  // public API expects snake_case query params
  {
    page,
    per_page: perPage,
    sort_field: sortField,
    sort_direction: sortDirection
  } :
  // internal API uses camelCase
  {
    page,
    perPage,
    sortField,
    sortDirection
  };
  return _kibana.KibanaServices.get().http.get(route, {
    version,
    query,
    signal
  });
};

/** Retrieves registered rule types. */
exports.findAttackDiscoverySchedule = findAttackDiscoverySchedule;
const fetchRuleTypes = async params => {
  const {
    signal
  } = params !== null && params !== void 0 ? params : {};
  return _kibana.KibanaServices.get().http.get(ALERTING_RULE_TYPES_URL, {
    signal
  });
};
exports.fetchRuleTypes = fetchRuleTypes;