"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnimatedCounter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var d3 = _interopRequireWildcard(require("d3"));
var _react2 = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/empty_states/empty_prompt/animated_counter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnimatedCounterComponent = ({
  animationDurationMs = 1000 * 1,
  count
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const d3Ref = (0, _react2.useRef)(null);
  const zero = 0; // counter starts at zero

  (0, _react2.useEffect)(() => {
    if (d3Ref.current) {
      d3.select(d3Ref.current).selectAll('*').remove();
      const svg = d3.select(d3Ref.current).append('svg');
      const text = svg.append('text').attr('y', 24).attr('fill', euiTheme.colors.textHeading).text(zero);
      text.transition().tween('text', function () {
        const selection = d3.select(this);
        const current = Number(d3.select(this).text());
        const interpolator = d3.interpolateNumber(current, count);
        return t => {
          selection.text(Math.round(interpolator(t)));
        };
      }).duration(animationDurationMs);
    }
  }, [animationDurationMs, count, euiTheme.colors.textHeading]);
  return /*#__PURE__*/_react2.default.createElement("svg", {
    css: (0, _react.css)`
        height: 32px;
        margin-right: ${euiTheme.size.xs};
        width: ${count < 100 ? 32 : 48}px;
      `,
    "data-test-subj": "animatedCounter",
    ref: d3Ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
const AnimatedCounter = exports.AnimatedCounter = /*#__PURE__*/_react2.default.memo(AnimatedCounterComponent);