"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeQuery = void 0;
var _zod = require("@kbn/zod");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const querySchema = _zod.z.object({
  query: _zod.z.union([_zod.z.string(), _zod.z.object({}).catchall(_zod.z.unknown())]),
  language: _zod.z.string()
});
const deserializeQuery = value => {
  try {
    return querySchema.parse(JSON.parse(value));
  } catch {
    return (0, _helpers.getDefaultQuery)();
  }
};
exports.deserializeQuery = deserializeQuery;