"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnboardingSuccessCallout = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to manage the visibility of the onboarding success callout
 * initializing as false by default, so the callout is only displayed when manually enabled
 * during the onboarding process.
 */
const useOnboardingSuccessCallout = () => {
  const [isOnboardingSuccessCalloutVisible, setOnboardingSuccessCalloutVisible] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_ONBOARDING_SUCCESS_CALLOUT_KEY, false);
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const hideOnboardingSuccessCallout = () => setOnboardingSuccessCalloutVisible(false);
  const showOnboardingSuccessCallout = () => setOnboardingSuccessCalloutVisible(true);
  const onAddIntegrationClick = () => application.navigateToApp(_common.INTEGRATIONS_PLUGIN_ID);
  return {
    isOnboardingSuccessCalloutVisible,
    hideOnboardingSuccessCallout,
    showOnboardingSuccessCallout,
    onAddIntegrationClick
  };
};
exports.useOnboardingSuccessCallout = useOnboardingSuccessCallout;