"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnableAssetInventory = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _use_asset_inventory_routes = require("../../../hooks/use_asset_inventory_routes");
var _use_asset_inventory_status = require("../../../hooks/use_asset_inventory_status");
var _use_onboarding_success_callout = require("./use_onboarding_success_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook with related business logic for enabling Asset Inventory
 */
const useEnableAssetInventory = () => {
  var _mutation$error, _mutation$error$body;
  const {
    postEnableAssetInventory
  } = (0, _use_asset_inventory_routes.useAssetInventoryRoutes)();
  const {
    refetch: refetchStatus
  } = (0, _use_asset_inventory_status.useAssetInventoryStatus)();
  const {
    showOnboardingSuccessCallout
  } = (0, _use_onboarding_success_callout.useOnboardingSuccessCallout)();
  const mutation = (0, _reactQuery.useMutation)(postEnableAssetInventory, {
    onSuccess: () => {
      // ensure the success callout will be visible after enabling Asset Inventory
      showOnboardingSuccessCallout();
      // re-fetch the status API to update the UI
      refetchStatus();
    }
  });
  const errorMessage = ((_mutation$error = mutation.error) === null || _mutation$error === void 0 ? void 0 : (_mutation$error$body = _mutation$error.body) === null || _mutation$error$body === void 0 ? void 0 : _mutation$error$body.message) || _i18n.i18n.translate('xpack.securitySolution.assetInventory.onboarding.enableAssetInventory.error', {
    defaultMessage: 'Failed to enable Asset Inventory. Please try again.'
  });

  // isEnabling is true when the mutation is loading and after it has succeeded so that the UI
  // can show a loading spinner while the status is being re-fetched
  const isEnabling = mutation.isLoading || mutation.isSuccess;
  return {
    isEnabling,
    error: mutation.isError ? errorMessage : null,
    reset: mutation.reset,
    enableAssetInventory: () => mutation.mutate()
  };
};
exports.useEnableAssetInventory = useEnableAssetInventory;