"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResourceIdentifier = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _splunk = require("./splunk");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const identifiers = {
  splunk: _splunk.splResourceIdentifier
};

// Type for a class that extends the ResourceIdentifier abstract class

class ResourceIdentifier {
  constructor(vendor) {
    (0, _defineProperty2.default)(this, "identifier", void 0);
    this.vendor = vendor;
    // The constructor may need query_language as an argument for other vendors
    this.identifier = identifiers[this.vendor];
  }
  fromQuery(query) {
    return this.identifier(query);
  }
  async fromOriginals(originalItem) {
    const lookups = new Set();
    const macros = new Set();
    for (const item of originalItem) {
      const resources = await this.fromOriginal(item);
      resources.forEach(resource => {
        if (resource.type === 'macro') {
          macros.add(resource.name);
        } else if (resource.type === 'lookup') {
          lookups.add(resource.name);
        }
      });
    }
    return [...Array.from(macros).map(name => ({
      type: 'macro',
      name
    })), ...Array.from(lookups).map(name => ({
      type: 'lookup',
      name
    }))];
  }
  fromResource(resource) {
    if (resource.type === 'macro' && resource.content) {
      return this.identifier(resource.content);
    }
    return [];
  }
  fromResources(resources) {
    const lookups = new Set();
    const macros = new Set();
    resources.forEach(resource => {
      this.fromResource(resource).forEach(identifiedResource => {
        if (identifiedResource.type === 'macro') {
          macros.add(identifiedResource.name);
        } else if (identifiedResource.type === 'lookup') {
          lookups.add(identifiedResource.name);
        }
      });
    });
    return [...Array.from(macros).map(name => ({
      type: 'macro',
      name
    })), ...Array.from(lookups).map(name => ({
      type: 'lookup',
      name
    }))];
  }
}
exports.ResourceIdentifier = ResourceIdentifier;