"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexEndpointPolicyResponse = exports.deleteIndexedEndpointPolicyResponse = void 0;
var _utils = require("./utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexEndpointPolicyResponse = async (esClient, policyResponse) => {
  const {
    _index: index,
    _id: id
  } = await esClient.index({
    index: _constants.POLICY_RESPONSE_INDEX,
    body: policyResponse,
    op_type: 'create',
    refresh: 'wait_for'
  }).catch(_utils.wrapErrorAndRejectPromise);
  const response = {
    policyResponses: [policyResponse],
    index,
    id
  };
  return response;
};
exports.indexEndpointPolicyResponse = indexEndpointPolicyResponse;
const deleteIndexedEndpointPolicyResponse = async (esClient, indexedData) => {
  await esClient.delete({
    index: indexedData.index,
    id: indexedData.id,
    refresh: 'wait_for'
  }, {
    ignore: [404]
  }).catch(_utils.wrapErrorAndRejectPromise);
};
exports.deleteIndexedEndpointPolicyResponse = deleteIndexedEndpointPolicyResponse;