"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeFilterArray = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeFilterArray = filters => {
  if (!(filters !== null && filters !== void 0 && filters.length)) {
    return [];
  }
  return filters.map(filter => {
    var _filter$meta$disabled, _filter$meta, _filter$meta$type, _filter$meta$alias, _filter$meta$key;
    return {
      query: filter.query,
      meta: filter.meta ? {
        negate: filter.meta.negate,
        disabled: (_filter$meta$disabled = filter.meta.disabled) !== null && _filter$meta$disabled !== void 0 ? _filter$meta$disabled : false,
        params: filter.meta.params,
        relation: 'relation' in filter.meta ? (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.relation : undefined,
        type: (_filter$meta$type = filter.meta.type) !== null && _filter$meta$type !== void 0 ? _filter$meta$type : 'custom',
        alias: (_filter$meta$alias = filter.meta.alias) !== null && _filter$meta$alias !== void 0 ? _filter$meta$alias : undefined,
        key: (_filter$meta$key = filter.meta.key) !== null && _filter$meta$key !== void 0 ? _filter$meta$key : undefined
      } : undefined
    };
  });
};
exports.normalizeFilterArray = normalizeFilterArray;