"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectIds = exports.GetNotesResult = exports.GetNotesResponse = exports.GetNotesRequestQuery = exports.DocumentIds = exports.AssociatedFilterTypeEnum = exports.AssociatedFilterType = void 0;
var _zod = require("@kbn/zod");
var _components = require("../model/components.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Elastic Security - Timeline - Notes API
 *   version: 2023-10-31
 */

/**
 * Filter notes based on their association with a document or saved object.
 */

const AssociatedFilterType = exports.AssociatedFilterType = _zod.z.enum(['all', 'document_only', 'saved_object_only', 'document_and_saved_object', 'orphan']);
const AssociatedFilterTypeEnum = exports.AssociatedFilterTypeEnum = AssociatedFilterType.enum;
const DocumentIds = exports.DocumentIds = _zod.z.union([_zod.z.array(_zod.z.string()), _zod.z.string()]);
const SavedObjectIds = exports.SavedObjectIds = _zod.z.union([_zod.z.array(_zod.z.string()), _zod.z.string()]);
const GetNotesResult = exports.GetNotesResult = _zod.z.object({
  totalCount: _zod.z.number(),
  notes: _zod.z.array(_components.Note)
});
const GetNotesRequestQuery = exports.GetNotesRequestQuery = _zod.z.object({
  documentIds: DocumentIds.optional(),
  savedObjectIds: SavedObjectIds.optional(),
  page: _zod.z.string().nullable().optional(),
  perPage: _zod.z.string().nullable().optional(),
  search: _zod.z.string().nullable().optional(),
  sortField: _zod.z.string().nullable().optional(),
  sortOrder: _zod.z.string().nullable().optional(),
  filter: _zod.z.string().nullable().optional(),
  createdByFilter: _zod.z.string().nullable().optional(),
  associatedFilter: AssociatedFilterType.optional()
});
const GetNotesResponse = exports.GetNotesResponse = GetNotesResult;