"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskManagerUnavailableResponse = exports.RiskScoreWeights = exports.RiskScoreWeightInternal = exports.RiskScoreWeightGlobalShared = exports.RiskScoreWeight = exports.RiskScoreInput = exports.RiskScoreEntityIdentifierWeights = exports.RiskScoreCategories = exports.PageSize = exports.KibanaDate = exports.IdentifierTypeEnum = exports.IdentifierType = exports.Filter = exports.EntityRiskScoreRecord = exports.EntityRiskLevelsEnum = exports.EntityRiskLevels = exports.EntityAnalyticsPrivileges = exports.EntityAfterKey = exports.DateRange = exports.DataViewId = exports.AfterKeys = void 0;
var _zod = require("@kbn/zod");
var _common = require("../asset_criticality/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Entity Analytics Common Schema
 *   version: 1
 */

const EntityAnalyticsPrivileges = exports.EntityAnalyticsPrivileges = _zod.z.object({
  has_all_required: _zod.z.boolean(),
  has_read_permissions: _zod.z.boolean().optional(),
  has_write_permissions: _zod.z.boolean().optional(),
  privileges: _zod.z.object({
    elasticsearch: _zod.z.object({
      cluster: _zod.z.object({}).catchall(_zod.z.boolean()).optional(),
      index: _zod.z.object({}).catchall(_zod.z.object({}).catchall(_zod.z.boolean())).optional()
    }),
    kibana: _zod.z.object({}).catchall(_zod.z.boolean()).optional()
  })
});
const EntityAfterKey = exports.EntityAfterKey = _zod.z.object({}).catchall(_zod.z.string());
const AfterKeys = exports.AfterKeys = _zod.z.object({
  host: EntityAfterKey.optional(),
  user: EntityAfterKey.optional(),
  service: EntityAfterKey.optional(),
  generic: EntityAfterKey.optional()
});

/**
 * The identifier of the Kibana data view to be used when generating risk scores.
 */

const DataViewId = exports.DataViewId = _zod.z.string();

/**
 * An elasticsearch DSL filter object. Used to filter the risk inputs involved, which implicitly filters the risk scores themselves.
 */

const Filter = exports.Filter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Specifies how many scores will be involved in a given calculation. Note that this value is per `identifier_type`, i.e. a value of 10 will calculate 10 host scores and 10 user scores, if available. To avoid missed data, keep this value consistent while paginating through scores.
 */

const PageSize = exports.PageSize = _zod.z.number().default(1000);
const KibanaDate = exports.KibanaDate = _zod.z.string();

/**
 * Defines the time period on which risk inputs will be filtered.
 */

const DateRange = exports.DateRange = _zod.z.object({
  start: KibanaDate,
  end: KibanaDate
});
const IdentifierType = exports.IdentifierType = _zod.z.enum(['host', 'user', 'service', 'generic']);
const IdentifierTypeEnum = exports.IdentifierTypeEnum = IdentifierType.enum;

/**
 * A generic representation of a document contributing to a Risk Score.
 */

const RiskScoreInput = exports.RiskScoreInput = _zod.z.object({
  /**
   * The unique identifier (`_id`) of the original source document
   */
  id: _zod.z.string(),
  /**
   * The unique index (`_index`) of the original source document
   */
  index: _zod.z.string(),
  /**
   * The risk category of the risk input document.
   */
  category: _zod.z.string(),
  /**
   * A human-readable description of the risk input document.
   */
  description: _zod.z.string(),
  /**
   * The weighted risk score of the risk input document.
   */
  risk_score: _zod.z.number().min(0).max(100).optional(),
  /**
   * The @timestamp of the risk input document.
   */
  timestamp: _zod.z.string().optional(),
  contribution_score: _zod.z.number().optional()
});
const RiskScoreCategories = exports.RiskScoreCategories = _zod.z.literal('category_1');
const EntityRiskLevels = exports.EntityRiskLevels = _zod.z.enum(['Unknown', 'Low', 'Moderate', 'High', 'Critical']);
const EntityRiskLevelsEnum = exports.EntityRiskLevelsEnum = EntityRiskLevels.enum;
const EntityRiskScoreRecord = exports.EntityRiskScoreRecord = _zod.z.object({
  /**
   * The time at which the risk score was calculated.
   */
  '@timestamp': _zod.z.string().datetime(),
  /**
   * The identifier field defining this risk score. Coupled with `id_value`, uniquely identifies the entity being scored.
   */
  id_field: _zod.z.string(),
  /**
   * The identifier value defining this risk score. Coupled with `id_field`, uniquely identifies the entity being scored.
   */
  id_value: _zod.z.string(),
  /**
   * Lexical description of the entity's risk.
   */
  calculated_level: EntityRiskLevels,
  /**
   * The raw numeric value of the given entity's risk score.
   */
  calculated_score: _zod.z.number(),
  /**
   * The normalized numeric value of the given entity's risk score. Useful for comparing with other entities.
   */
  calculated_score_norm: _zod.z.number().min(0).max(100),
  /**
   * The contribution of Category 1 to the overall risk score (`calculated_score`). Category 1 contains Detection Engine Alerts.
   */
  category_1_score: _zod.z.number(),
  /**
   * The number of risk input documents that contributed to the Category 1 score (`category_1_score`).
   */
  category_1_count: _zod.z.number().int(),
  /**
   * A list of the highest-risk documents contributing to this risk score. Useful for investigative purposes.
   */
  inputs: _zod.z.array(RiskScoreInput),
  category_2_score: _zod.z.number().optional(),
  category_2_count: _zod.z.number().int().optional(),
  notes: _zod.z.array(_zod.z.string()),
  criticality_modifier: _zod.z.number().optional(),
  criticality_level: _common.AssetCriticalityLevel.optional()
});
const RiskScoreEntityIdentifierWeights = exports.RiskScoreEntityIdentifierWeights = _zod.z.number().min(0).max(1);
const RiskScoreWeightGlobalShared = exports.RiskScoreWeightGlobalShared = _zod.z.object({
  type: _zod.z.literal('global_identifier')
});
const RiskScoreWeightInternal = exports.RiskScoreWeightInternal = _zod.z.union([RiskScoreWeightGlobalShared.merge(_zod.z.object({
  host: RiskScoreEntityIdentifierWeights,
  user: RiskScoreEntityIdentifierWeights.optional(),
  service: RiskScoreEntityIdentifierWeights.optional(),
  generic: RiskScoreEntityIdentifierWeights.optional()
})), RiskScoreWeightGlobalShared.merge(_zod.z.object({
  host: RiskScoreEntityIdentifierWeights.optional(),
  user: RiskScoreEntityIdentifierWeights,
  service: RiskScoreEntityIdentifierWeights.optional(),
  generic: RiskScoreEntityIdentifierWeights.optional()
})), RiskScoreWeightGlobalShared.merge(_zod.z.object({
  host: RiskScoreEntityIdentifierWeights.optional(),
  user: RiskScoreEntityIdentifierWeights.optional(),
  service: RiskScoreEntityIdentifierWeights,
  generic: RiskScoreEntityIdentifierWeights.optional()
}))]);
const RiskScoreWeight = exports.RiskScoreWeight = RiskScoreWeightInternal;

/**
 * A list of weights to be applied to the scoring calculation.
 */

const RiskScoreWeights = exports.RiskScoreWeights = _zod.z.array(RiskScoreWeight);

/**
 * Task manager is unavailable
 */

const TaskManagerUnavailableResponse = exports.TaskManagerUnavailableResponse = _zod.z.object({
  status_code: _zod.z.number().int().min(400),
  message: _zod.z.string()
});