"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePatchRuleRequestBody = void 0;
var _threshold = require("../../../../../utils/request_validation/threshold");
var _indicator_match = require("../../../../../utils/request_validation/indicator_match");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Additional validation that is implemented outside of the schema itself.
 */
const validatePatchRuleRequestBody = rule => {
  return [...validateId(rule), ...validateTimelineId(rule), ...validateTimelineTitle(rule), ...validateThreshold(rule), ...(0, _indicator_match.validateThreatMapping)(rule)];
};
exports.validatePatchRuleRequestBody = validatePatchRuleRequestBody;
const validateId = rule => {
  if (rule.id != null && rule.rule_id != null) {
    return ['both "id" and "rule_id" cannot exist, choose one or the other'];
  } else if (rule.id == null && rule.rule_id == null) {
    return ['either "id" or "rule_id" must be set'];
  } else {
    return [];
  }
};
const validateTimelineId = rule => {
  if (rule.timeline_id != null) {
    if (rule.timeline_title == null) {
      return ['when "timeline_id" exists, "timeline_title" must also exist'];
    } else if (rule.timeline_id === '') {
      return ['"timeline_id" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateTimelineTitle = rule => {
  if (rule.timeline_title != null) {
    if (rule.timeline_id == null) {
      return ['when "timeline_title" exists, "timeline_id" must also exist'];
    } else if (rule.timeline_title === '') {
      return ['"timeline_title" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateThreshold = rule => (0, _threshold.validateThresholdBase)(rule);