"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMapV3 = exports.getCasesBaseKibanaSubFeatureIdsV3 = void 0;
var _product_features_keys = require("../../product_features_keys");
var _kibana_sub_features = require("../kibana_sub_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIdsV3 = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings, _product_features_keys.CasesSubFeatureId.createComment, _product_features_keys.CasesSubFeatureId.reopenCase, _product_features_keys.CasesSubFeatureId.assignUsers];
exports.getCasesBaseKibanaSubFeatureIdsV3 = getCasesBaseKibanaSubFeatureIdsV3;
const getCasesSubFeaturesMapV3 = params => {
  return new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, (0, _kibana_sub_features.getDeleteCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.casesSettings, (0, _kibana_sub_features.getCasesSettingsCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.createComment, (0, _kibana_sub_features.getCasesAddCommentsCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.reopenCase, (0, _kibana_sub_features.getCasesReopenCaseSubFeature)(params)], /* The below sub features were newly added in V3 */
  [_product_features_keys.CasesSubFeatureId.assignUsers, (0, _kibana_sub_features.getCasesAssignUsersCasesSubFeature)(params)]]);
};
exports.getCasesSubFeaturesMapV3 = getCasesSubFeaturesMapV3;