"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSpacesClient = void 0;
var _server = require("@kbn/core/server");
var _secure_spaces_client_wrapper = require("./secure_spaces_client_wrapper");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupSpacesClient = ({
  audit,
  authz,
  spaces,
  getCurrentUser,
  getTypeRegistry
}) => {
  if (!spaces) {
    return;
  }
  const {
    spacesClient
  } = spaces;
  spacesClient.setClientRepositoryFactory((request, savedObjectsStart) => {
    if (authz.mode.useRbacForRequest(request)) {
      return savedObjectsStart.createInternalRepository(['space']);
    }
    return savedObjectsStart.createScopedRepository(request, ['space']);
  });
  spacesClient.registerClientWrapper((request, baseClient) => {
    const securityExtension = authz.mode.useRbacForRequest(request) ? new _saved_objects.SavedObjectsSecurityExtension({
      actions: authz.actions,
      auditLogger: audit.asScoped(request),
      checkPrivileges: authz.checkSavedObjectsPrivilegesWithRequest(request),
      errors: _server.SavedObjectsClient.errors,
      getCurrentUser: () => getCurrentUser(request)
    }) : undefined;
    return new _secure_spaces_client_wrapper.SecureSpacesClientWrapper(baseClient, request, authz, audit.asScoped(request), _server.SavedObjectsClient.errors, securityExtension, getTypeRegistry);
  });
};
exports.setupSpacesClient = setupSpacesClient;