"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSpaceTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./privilege_space_table.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _securityUiComponents = require("@kbn/security-ui-components");
var _public = require("@kbn/spaces-plugin/public");
var _privilege_display = require("./privilege_display");
var _model = require("../../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/space_aware_privilege_section/privilege_space_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SPACES_DISPLAY_COUNT = 4;
class PrivilegeSpaceTable extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      expandedSpacesGroups: []
    });
    (0, _defineProperty2.default)(this, "renderKibanaPrivileges", () => {
      const {
        privilegeCalculator,
        displaySpaces
      } = this.props;
      const spacePrivileges = this.getSortedPrivileges();
      const rows = spacePrivileges.map((spacePrivs, privilegeIndex) => {
        const spaces = spacePrivs.spaces.map(spaceId => displaySpaces.find(space => space.id === spaceId) || {
          id: spaceId,
          name: spaceId,
          disabledFeatures: [],
          deleted: true
        });
        return {
          spaces,
          privilegeIndex,
          isGlobal: (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(spacePrivs),
          privileges: {
            spaces: spacePrivs.spaces,
            base: spacePrivs.base || [],
            feature: spacePrivs.feature || {},
            reserved: spacePrivs._reserved || []
          }
        };
      });
      const getExtraBadgeProps = space => {
        if (space.deleted) {
          return {
            iconType: 'trash'
          };
        }
        return {};
      };
      const columns = [{
        field: 'spaces',
        name: 'Spaces',
        width: '60%',
        render: (spaces, record) => {
          const isExpanded = this.state.expandedSpacesGroups.includes(record.privilegeIndex);
          const displayedSpaces = isExpanded ? spaces : spaces.slice(0, SPACES_DISPLAY_COUNT);
          let button = null;
          if (spaces.length > displayedSpaces.length) {
            button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
              size: "xs",
              onClick: () => this.toggleExpandSpacesGroup(record.privilegeIndex),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 125,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.spacePrivilegeTable.showNMoreSpacesLink",
              defaultMessage: "+{count} more",
              values: {
                count: spaces.length - displayedSpaces.length
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 129,
                columnNumber: 17
              }
            }));
          } else if (isExpanded) {
            button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
              size: "xs",
              onClick: () => this.toggleExpandSpacesGroup(record.privilegeIndex),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 138,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.spacePrivilegeTable.showLessSpacesLink",
              defaultMessage: "show less",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 142,
                columnNumber: 17
              }
            }));
          }
          return /*#__PURE__*/_react.default.createElement("div", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 151,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "spacesColumn",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 15
            }
          }, displayedSpaces.map(space => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
            key: space.id
          }, getExtraBadgeProps(space), {
            color: (0, _public.getSpaceColor)(space),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 154,
              columnNumber: 19
            }
          }), space.name))), button);
        }
      }, {
        field: 'privileges',
        name: 'Privileges',
        render: (privileges, record) => {
          var _privilegeCalculator$, _privilegeCalculator$2;
          if (privileges.reserved.length > 0) {
            return /*#__PURE__*/_react.default.createElement(_privilege_display.PrivilegeDisplay, {
              privilege: privileges.reserved,
              "data-test-subj": `privilegeColumn`,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 175,
                columnNumber: 15
              }
            });
          }
          const basePrivilege = (_privilegeCalculator$ = (_privilegeCalculator$2 = privilegeCalculator.getBasePrivilege(record.privilegeIndex)) === null || _privilegeCalculator$2 === void 0 ? void 0 : _privilegeCalculator$2.id) !== null && _privilegeCalculator$ !== void 0 ? _privilegeCalculator$ : _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE;
          const privilege = privilegeCalculator.isWildcardBasePrivilege(record.privilegeIndex) ? '*' : basePrivilege;
          let icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "empty",
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 190,
              columnNumber: 22
            }
          });
          if (privilegeCalculator.hasSupersededInheritedPrivileges(record.privilegeIndex)) {
            icon = /*#__PURE__*/_react.default.createElement("span", {
              "data-test-subj": "spaceTablePrivilegeSupersededWarning",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 193,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
              type: "warning",
              size: "s",
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.security.management.editRole.spacePrivilegeTable.supersededPrivilegeWarning",
                defaultMessage: "Privileges are superseded by configured global privilege. View the privilege summary to see effective privileges.",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 198,
                  columnNumber: 21
                }
              }),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 194,
                columnNumber: 17
              }
            }));
          }
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 209,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 210,
              columnNumber: 15
            }
          }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 211,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_privilege_display.PrivilegeDisplay, {
            privilege: privilege,
            "data-test-subj": `privilegeColumn`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 212,
              columnNumber: 17
            }
          })));
        }
      }];
      if (!this.props.disabled) {
        columns.push({
          name: 'Actions',
          actions: [{
            render: record => {
              return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
                "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeTable.editPrivilegesLabel', {
                  defaultMessage: `Edit privileges for the following spaces: {spaceNames}.`,
                  values: {
                    spaceNames: record.spaces.map(s => s.name).join(', ')
                  }
                }),
                color: 'primary',
                iconType: 'pencil',
                onClick: () => this.props.onEdit(record.privilegeIndex),
                "data-test-subj": `privilegeEditAction-${record.privilegeIndex}`,
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 227,
                  columnNumber: 17
                }
              });
            }
          }, {
            render: record => {
              return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
                "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeTable.deletePrivilegesLabel', {
                  defaultMessage: `Delete privileges for the following spaces: {spaceNames}.`,
                  values: {
                    spaceNames: record.spaces.map(s => s.name).join(', ')
                  }
                }),
                color: 'danger',
                iconType: 'trash',
                onClick: () => this.onDeleteSpacePrivilege(record),
                "data-test-subj": `privilegeDeleteAction-${record.privilegeIndex}`,
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 246,
                  columnNumber: 17
                }
              });
            }
          }]
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        tableCaption: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeTable.caption', {
          defaultMessage: 'Space privilege assignments'
        }),
        columns: columns,
        items: rows,
        rowProps: item => {
          return {
            className: (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(item.privileges) ? 'secPrivilegeTable__row--isGlobalSpace' : ''
          };
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "getSortedPrivileges", () => {
      const spacePrivileges = this.props.role.kibana;
      return spacePrivileges.sort((priv1, priv2) => {
        return (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(priv1) ? -1 : (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(priv2) ? 1 : 0;
      });
    });
    (0, _defineProperty2.default)(this, "toggleExpandSpacesGroup", privilegeIndex => {
      if (this.state.expandedSpacesGroups.includes(privilegeIndex)) {
        this.setState({
          expandedSpacesGroups: this.state.expandedSpacesGroups.filter(i => i !== privilegeIndex)
        });
      } else {
        this.setState({
          expandedSpacesGroups: [...this.state.expandedSpacesGroups, privilegeIndex]
        });
      }
    });
    (0, _defineProperty2.default)(this, "onDeleteSpacePrivilege", item => {
      const roleCopy = (0, _model.copyRole)(this.props.role);
      roleCopy.kibana.splice(item.privilegeIndex, 1);
      this.props.onChange(roleCopy);
      this.setState({
        expandedSpacesGroups: this.state.expandedSpacesGroups.filter(i => i !== item.privilegeIndex)
      });
    });
  }
  render() {
    return this.renderKibanaPrivileges();
  }
}
exports.PrivilegeSpaceTable = PrivilegeSpaceTable;