"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimplePrivilegeSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _securityUiComponents = require("@kbn/security-ui-components");
var _unsupported_space_privileges_warning = require("./unsupported_space_privileges_warning");
var _model = require("../../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/simple_privilege_section/simple_privilege_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SimplePrivilegeSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getDisplayedBasePrivilege", () => {
      if (this.state.isCustomizingGlobalPrivilege) {
        return _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE;
      }
      const {
        role
      } = this.props;
      const form = this.locateGlobalPrivilege(role);
      return form && form.base.length > 0 ? form.base[0] : _securityUiComponents.constants.NO_PRIVILEGE_VALUE;
    });
    (0, _defineProperty2.default)(this, "onKibanaPrivilegeChange", privilege => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privilege === _securityUiComponents.constants.NO_PRIVILEGE_VALUE) {
        // Remove global entry if no privilege value
        role.kibana = role.kibana.filter(entry => !(0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(entry));
      } else if (privilege === _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE) {
        // Remove base privilege if customizing feature privileges
        form.base = [];
      } else {
        form.base = [privilege];
        form.feature = {};
      }
      this.props.onChange(role);
      this.setState({
        isCustomizingGlobalPrivilege: privilege === _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE,
        globalPrivsIndex: role.kibana.indexOf(form)
      });
    });
    (0, _defineProperty2.default)(this, "onFeaturePrivilegeChange", (featureId, privileges) => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privileges.length > 0) {
        form.feature[featureId] = [...privileges];
      } else {
        delete form.feature[featureId];
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onChangeAllFeaturePrivileges", privileges => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privileges.length > 0) {
        this.props.kibanaPrivileges.getSecuredFeatures().forEach(feature => {
          form.feature[feature.id] = [...privileges];
        });
      } else {
        form.feature = {};
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "maybeRenderSpacePrivilegeWarning", () => {
      const kibanaPrivileges = this.props.role.kibana;
      const hasSpacePrivileges = kibanaPrivileges.some(privilege => !(0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(privilege));
      if (hasSpacePrivileges) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 311,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_unsupported_space_privileges_warning.UnsupportedSpacePrivilegesWarning, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 312,
            columnNumber: 11
          }
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "locateGlobalPrivilegeIndex", role => {
      return role.kibana.findIndex(privileges => (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(privileges));
    });
    (0, _defineProperty2.default)(this, "locateGlobalPrivilege", role => {
      const spacePrivileges = role.kibana;
      return spacePrivileges.find(privileges => (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(privileges));
    });
    const globalPrivs = this.locateGlobalPrivilege(props.role);
    const globalPrivsIndex = this.locateGlobalPrivilegeIndex(props.role);
    this.state = {
      isCustomizingGlobalPrivilege: Boolean(globalPrivs && Object.keys(globalPrivs.feature).length > 0),
      globalPrivsIndex
    };
  }
  render() {
    var _this$props$role$kiba, _this$props$role$kiba2;
    const kibanaPrivilege = this.getDisplayedBasePrivilege();
    const reservedPrivileges = (_this$props$role$kiba = (_this$props$role$kiba2 = this.props.role.kibana[this.state.globalPrivsIndex]) === null || _this$props$role$kiba2 === void 0 ? void 0 : _this$props$role$kiba2._reserved) !== null && _this$props$role$kiba !== void 0 ? _this$props$role$kiba : [];
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.simplePrivilegeForm.kibanaPrivilegesTitle",
      defaultMessage: "Kibana privileges",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    });
    const description = /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.simplePrivilegeForm.specifyPrivilegeForRoleDescription",
      defaultMessage: "Specifies the Kibana privilege for this role.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, reservedPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      selectedOptions: reservedPrivileges.map(rp => ({
        label: rp
      })),
      isDisabled: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      disabled: !this.props.editable,
      onChange: this.onKibanaPrivilegeChange,
      options: [{
        value: _securityUiComponents.constants.NO_PRIVILEGE_VALUE,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeInput",
          defaultMessage: "None",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 25
          }
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeDropdown",
          defaultMessage: "None",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 29
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeDropdownDescription",
          defaultMessage: "No access to Kibana",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 31
          }
        }))))
      }, {
        value: 'read',
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeInput",
          defaultMessage: "Read",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 25
          }
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeDropdown",
          defaultMessage: "Read",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 29
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeDropdownDescription",
          defaultMessage: "Grants read-only access to all of Kibana",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 31
          }
        }))))
      }, {
        value: 'all',
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeInput",
          defaultMessage: "All",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 25
          }
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 166,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeDropdown",
          defaultMessage: "All",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 29
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 172,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeDropdownDescription",
          defaultMessage: "Grants full access to all of Kibana",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 31
          }
        }))))
      }, {
        value: _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeInput",
          defaultMessage: "Custom",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 25
          }
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeDropdown",
          defaultMessage: "Custom",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 29
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 199,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 200,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeDropdownDescription",
          defaultMessage: "Customize access to Kibana",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 201,
            columnNumber: 31
          }
        }))))
      }],
      hasDividers: true,
      valueOfSelected: kibanaPrivilege,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    })), this.state.isCustomizingGlobalPrivilege && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_securityUiComponents.KibanaPrivilegeTable, {
      role: this.props.role,
      kibanaPrivileges: this.props.kibanaPrivileges,
      privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(this.props.kibanaPrivileges, this.props.role),
      onChange: this.onFeaturePrivilegeChange,
      onChangeAll: this.onChangeAllFeaturePrivileges,
      privilegeIndex: this.props.role.kibana.findIndex(k => (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(k)),
      showAdditionalPermissionsMessage: true,
      canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges,
      allSpacesSelected: true,
      disabled: !this.props.editable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 17
      }
    })), this.maybeRenderSpacePrivilegeWarning())));
  }
  createGlobalPrivilegeEntry(role) {
    const newEntry = {
      spaces: ['*'],
      base: [],
      feature: {}
    };
    role.kibana.push(newEntry);
    return newEntry;
  }
}
exports.SimplePrivilegeSection = SimplePrivilegeSection;