"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPrivilegesRegion = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _simple_privilege_section = require("./simple_privilege_section");
var _space_aware_privilege_section = require("./space_aware_privilege_section");
var _transform_error_section = require("./transform_error_section");
var _collapsible_panel = require("../../collapsible_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/kibana_privileges_region.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class KibanaPrivilegesRegion extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        kibanaPrivileges,
        role,
        spacesEnabled,
        canCustomizeSubFeaturePrivileges,
        spaces = [],
        uiCapabilities,
        onChange,
        editable,
        validator,
        spacesApiUi
      } = this.props;
      if (role._transform_error && role._transform_error.some(error => error.reason.startsWith('kibana'))) {
        return /*#__PURE__*/_react.default.createElement(_transform_error_section.TransformErrorSection, {
          transformErrors: role._transform_error,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 14
          }
        });
      }
      if (spacesApiUi && spacesEnabled) {
        return /*#__PURE__*/_react.default.createElement(_space_aware_privilege_section.SpaceAwarePrivilegeSection, {
          kibanaPrivileges: kibanaPrivileges,
          role: role,
          spaces: spaces,
          uiCapabilities: uiCapabilities,
          onChange: onChange,
          editable: editable,
          canCustomizeSubFeaturePrivileges: canCustomizeSubFeaturePrivileges,
          validator: validator,
          spacesApiUi: spacesApiUi,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 9
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_simple_privilege_section.SimplePrivilegeSection, {
        kibanaPrivileges: kibanaPrivileges,
        role: role,
        onChange: onChange,
        editable: editable,
        canCustomizeSubFeaturePrivileges: canCustomizeSubFeaturePrivileges,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 7
        }
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
      iconType: 'logoKibana',
      title: 'Kibana',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }, this.getForm());
  }
}
exports.KibanaPrivilegesRegion = KibanaPrivilegesRegion;