"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPlaygroundSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../common");
var _v = require("./schema/v1/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPlaygroundSavedObjectType = () => ({
  name: _common.PLAYGROUND_SAVED_OBJECT_TYPE,
  indexPattern: _coreSavedObjectsServer.SEARCH_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      name: {
        type: 'text',
        fields: {
          keyword: {
            type: 'keyword'
          }
        }
      }
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: _v.playgroundAttributesSchema.extends({}, {
          unknowns: 'ignore'
        }),
        create: _v.playgroundAttributesSchema
      }
    }
  }
});
exports.createPlaygroundSavedObjectType = createPlaygroundSavedObjectType;