"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isElasticConnector = isElasticConnector;
exports.parsePlaygroundConnectors = parsePlaygroundConnectors;
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _i18n = require("@kbn/i18n");
var _inferenceCommon = require("@kbn/inference-common");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isOpenAIConnector(connector) {
  return connector.actionTypeId === _common.OPENAI_CONNECTOR_ID;
}
const connectorTypeToLLM = [{
  actionId: _common.OPENAI_CONNECTOR_ID,
  actionProvider: _common.OpenAiProviderType.AzureAi,
  match: connector => {
    var _connector$config;
    return isOpenAIConnector(connector) && (connector === null || connector === void 0 ? void 0 : (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.apiProvider) === _common.OpenAiProviderType.AzureAi;
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIAzureConnectorTitle', {
      defaultMessage: 'OpenAI Azure'
    }),
    type: _types.LLMs.openai_azure
  })
}, {
  actionId: _common.OPENAI_CONNECTOR_ID,
  match: connector => {
    var _connector$config2;
    return isOpenAIConnector(connector) && ((connector === null || connector === void 0 ? void 0 : (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : _connector$config2.apiProvider) === _common.OpenAiProviderType.OpenAi || Boolean(connector.isPreconfigured));
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIConnectorTitle', {
      defaultMessage: 'OpenAI'
    }),
    type: _types.LLMs.openai
  })
}, {
  actionId: _common.OPENAI_CONNECTOR_ID,
  actionProvider: _common.OpenAiProviderType.Other,
  match: connector => {
    var _connector$config3;
    return isOpenAIConnector(connector) && (connector === null || connector === void 0 ? void 0 : (_connector$config3 = connector.config) === null || _connector$config3 === void 0 ? void 0 : _connector$config3.apiProvider) === _common.OpenAiProviderType.Other;
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIOtherConnectorTitle', {
      defaultMessage: 'OpenAI Other'
    }),
    type: _types.LLMs.openai_other
  })
}, {
  actionId: _common.BEDROCK_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.BEDROCK_CONNECTOR_ID,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.bedrockConnectorTitle', {
      defaultMessage: 'Bedrock'
    }),
    type: _types.LLMs.bedrock
  })
}, {
  actionId: _common.GEMINI_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.GEMINI_CONNECTOR_ID,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.geminiConnectorTitle', {
      defaultMessage: 'Gemini'
    }),
    type: _types.LLMs.gemini
  })
}, {
  actionId: _common.INFERENCE_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.INFERENCE_CONNECTOR_ID && (0, _inferenceCommon.isSupportedConnector)(connector),
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.aiConnectorTitle', {
      defaultMessage: 'AI Connector'
    }),
    type: _types.LLMs.inference
  })
}];
function isInferenceActionConnector(connector) {
  return connector.actionTypeId === _common.INFERENCE_CONNECTOR_ID && (0, _inferenceCommon.isSupportedConnector)(connector);
}
async function parsePlaygroundConnectors(connectors, http) {
  const playgroundConnectors = [];
  for (const connector of connectors) {
    const {
      transform
    } = connectorTypeToLLM.find(({
      match
    }) => match(connector)) || {};
    if (transform === undefined) continue;
    if (connector.isMissingSecrets) continue;
    if (!isInferenceActionConnector(connector)) {
      playgroundConnectors.push(transform(connector));
    } else {
      const connectorInferenceEndpointExists = await (0, _inferenceEndpointUiCommon.isInferenceEndpointExists)(http, connector.config.inferenceId);
      if (connectorInferenceEndpointExists) {
        playgroundConnectors.push(transform(connector));
      }
    }
  }
  return playgroundConnectors;
}
function isElasticConnector(connector) {
  return isInferenceActionConnector(connector) && connector.isPreconfigured && connector.config.provider === 'elastic';
}