"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundUnavailable = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _common = require("../common");
var _page_template = require("./layout/page_template");
var _use_playground_breadcrumbs = require("./hooks/use_playground_breadcrumbs");
var _use_asset_base_path = require("./hooks/use_asset_base_path");
var _body = require("./components/playgrounds_list/empty_state/body");
var _licensing_cta = require("./components/licensing_cta");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/playground_unavailable_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Override styling for empty state to allow it to grow wider for content we provide
const EmptyStateStyle = (0, _react2.css)`
  min-inline-size: 64rem;
  .euiCard__content {
    max-inline-size: 60em;
  }
`;
const PlaygroundUnavailable = () => {
  (0, _use_playground_breadcrumbs.usePlaygroundBreadcrumbs)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  return /*#__PURE__*/_react.default.createElement(_page_template.SearchPlaygroundPageTemplate, {
    restrictWidth: false,
    "data-test-subj": "playgroundsUnlicensed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    css: EmptyStateStyle,
    display: "plain",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "xxl",
      src: `${assetBasePath}/search_lake.svg`,
      alt: "",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 18
      }
    }, _common.PLUGIN_NAME),
    betaBadgeProps: {
      label: _i18n.i18n.translate('xpack.searchPlayground.unavailable.licenseBadge.title', {
        defaultMessage: 'Enterprise Feature'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.searchPlayground.unavailable.licenseBadge.tooltip', {
        defaultMessage: 'You need an Enterprise license to use the Playground.'
      })
    },
    description: /*#__PURE__*/_react.default.createElement(_body.PlaygroundsListEmptyStateBody, {
      CTAContent: /*#__PURE__*/_react.default.createElement(_licensing_cta.PlaygroundLicensingCTA, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 67
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 24
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })));
};
exports.PlaygroundUnavailable = PlaygroundUnavailable;