"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowSetupPage = void 0;
var _react = require("react");
var _types = require("../types");
var _use_playground_parameters = require("./use_playground_parameters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShowSetupPage = ({
  hasSelectedIndices,
  hasConnectors
}) => {
  const [showSetupPage, setShowSetupPage] = (0, _react.useState)(true);
  const {
    pageMode
  } = (0, _use_playground_parameters.usePlaygroundParameters)();
  (0, _react.useEffect)(() => {
    if (pageMode === _types.PlaygroundPageMode.chat) {
      if (showSetupPage && hasConnectors && hasSelectedIndices) {
        setShowSetupPage(false);
      } else if (!showSetupPage && (!hasConnectors || !hasSelectedIndices)) {
        setShowSetupPage(true);
      }
    } else {
      if (showSetupPage && hasSelectedIndices) {
        setShowSetupPage(false);
      } else if (!showSetupPage && !hasSelectedIndices) {
        setShowSetupPage(true);
      }
    }
  }, [hasSelectedIndices, showSetupPage, pageMode, hasConnectors]);
  return {
    showSetupPage
  };
};
exports.useShowSetupPage = useShowSetupPage;