"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQuery = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQuery = query => {
  try {
    return JSON.stringify(query, null, 4).replace(/"{query}"/g, 'query').split('\n').map(line => `    ${line}`).join('\n').trim();
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error('Error parsing ES query', e);
    return '{}';
  }
};
exports.getESQuery = getESQuery;