"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectLLMButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/actions-plugin/common");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _use_load_connectors = require("../../hooks/use_load_connectors");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _playground_connectors = require("../../utils/playground_connectors");
var _elastic_connector_connected = require("./elastic_connector_connected");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/setup_page/connect_llm_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectLLMButton = () => {
  var _connectors$;
  const [connectorFlyoutOpen, setConnectorFlyoutOpen] = (0, _react.useState)(false);
  const [showCallout, setShowAddedCallout] = (0, _react.useState)(false);
  const {
    services: {
      triggersActionsUi: {
        getAddConnectorFlyout: ConnectorFlyout
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: connectors,
    refetch: refetchConnectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const handleConnectorCreated = () => {
    refetchConnectors();
    setShowAddedCallout(true);
    setConnectorFlyoutOpen(false);
  };
  const handleSetupGenAiConnector = () => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.genAiConnectorCreated);
    setConnectorFlyoutOpen(true);
  };
  (0, _react.useEffect)(() => {
    if (connectors !== null && connectors !== void 0 && connectors.length) {
      if (showCallout) {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorAdded);
      } else {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorExists);
      }
    } else {
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorSetup);
    }
  }, [connectors === null || connectors === void 0 ? void 0 : connectors.length, showCallout, usageTracker]);
  const hasConnectors = connectors === null || connectors === void 0 ? void 0 : connectors.length;
  const elasticConnector = hasConnectors ? connectors.find(_playground_connectors.isElasticConnector) : undefined;
  const hasElasticConnector = elasticConnector !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasConnectors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": "successConnectLLMText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, hasElasticConnector ? /*#__PURE__*/_react.default.createElement(_elastic_connector_connected.ElasticManagedConnector, {
    name: elasticConnector.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.llmConnectedButtonLabel",
    defaultMessage: "{connectorName} connected",
    values: {
      connectorName: ((_connectors$ = connectors[0]) === null || _connectors$ === void 0 ? void 0 : _connectors$.name) || 'LLM'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    target: "_blank",
    "data-test-subj": "manageConnectorsLink",
    iconType: "wrench",
    size: "s",
    onClick: handleSetupGenAiConnector,
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.setupPage.manageConnectorLink', {
      defaultMessage: 'Manage connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "sparkles",
    "data-test-subj": "connectLLMButton",
    onClick: handleSetupGenAiConnector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.connectLLMButtonLabel",
    defaultMessage: "Connect to an LLM",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), connectorFlyoutOpen && /*#__PURE__*/_react.default.createElement(ConnectorFlyout, {
    featureId: _common.GenerativeAIForSearchPlaygroundConnectorFeatureId,
    onConnectorCreated: handleConnectorCreated,
    onClose: () => setConnectorFlyoutOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }));
};
exports.ConnectLLMButton = ConnectLLMButton;