"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchMode = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _reactQuery = require("@kbn/react-query");
var _common = require("../../../common");
var _result_list = require("./result_list");
var _types = require("../../types");
var _use_search_preview = require("../../hooks/use_search_preview");
var _pagination_helper = require("../../utils/pagination_helper");
var _use_index_mappings = require("../../hooks/use_index_mappings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/search_mode/search_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SearchMode = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      value: searchBarValue
    },
    formState: {
      isSubmitting
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.searchQuery
  });
  const [searchQuery, setSearchQuery] = _react.default.useState({
    query: searchBarValue,
    pagination: _common.DEFAULT_PAGINATION
  });
  const {
    executionTime,
    results,
    pagination
  } = (0, _use_search_preview.useSearchPreview)(searchQuery);
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMappings)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const handleSearch = async (query = searchBarValue, paginationParam = _common.DEFAULT_PAGINATION) => {
    queryClient.resetQueries({
      queryKey: [_common.SearchPlaygroundQueryKeys.SearchPreviewResults]
    });
    setSearchQuery({
      query,
      pagination: paginationParam
    });
  };
  const onPagination = page => {
    handleSearch(searchBarValue, (0, _pagination_helper.getPaginationFromPage)(page, pagination.size, pagination));
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "top",
    restrictWidth: true,
    grow: true,
    css: {
      position: 'relative'
    },
    paddingSize: "xl",
    className: "eui-fullHeight",
    "data-test-subj": "playground-search-section",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
            max-width: ${euiTheme.base * 48}px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: _types.PlaygroundFormFields.searchQuery,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, (0, _extends2.default)({
      "data-test-subj": "searchPlaygroundSearchModeFieldText"
    }, field, {
      value: searchBarValue,
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.searchMode.searchBar.placeholder', {
        defaultMessage: 'Search for documents'
      }),
      isLoading: isSubmitting,
      isClearable: true,
      incremental: true,
      onSearch: handleSearch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }, searchQuery.query ? /*#__PURE__*/_react.default.createElement(_result_list.ResultList, {
    executionTime: executionTime,
    searchResults: results,
    mappings: mappingData,
    pagination: pagination,
    onPaginationChange: onPagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.searchMode.readyToSearch', {
      defaultMessage: 'We are ready to search!'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.searchMode.searchPrompt', {
      defaultMessage: 'Fine tune a traditional search with your data. Start by entering a query above to see what results you get and go from there!'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 21
    }
  }))))))));
};
exports.SearchMode = SearchMode;