"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _types = require("../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/query_mode/chat_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ChatPrompt = ({
  isLoading
}) => {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: _types.PlaygroundFormFields.question,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "searchPlaygroundChatQuestionFieldText",
      prepend: "{query}",
      name: field.name,
      onBlur: field.onBlur,
      onChange: field.onChange,
      value: field.value,
      inputRef: field.ref,
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.searchMode.queryView.chatQuestion.placeholder', {
        defaultMessage: 'Ask a question'
      }),
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
};
exports.ChatPrompt = ChatPrompt;