"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToDashboard = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARD_LOCATOR_ID = 'DASHBOARD_APP_LOCATOR';
const useNavigateToDashboard = dashboardId => {
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  return (0, _react.useCallback)(async () => {
    const dashboardLocator = share.url.locators.get(DASHBOARD_LOCATOR_ID);
    if (dashboardLocator && dashboardId) {
      await dashboardLocator.navigate({
        dashboardId
      });
    }
  }, [share, dashboardId]);
};
exports.useNavigateToDashboard = useNavigateToDashboard;