"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndex = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLLING_INTERVAL = 15 * 1000;
const useIndex = indexName => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryKey = [_constants.QueryKeys.FetchIndex, indexName];
  return (0, _reactQuery.useQuery)({
    queryKey,
    refetchInterval: POLLING_INTERVAL,
    refetchIntervalInBackground: true,
    refetchOnWindowFocus: 'always',
    retry: (failureCount, error) => {
      var _error$body;
      return !((error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404 || failureCount === 3);
    },
    queryFn: () => http.fetch(`/internal/index_management/indices/${encodeURIComponent(indexName)}`)
  });
};
exports.useIndex = useIndex;