"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGuideTour = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GUIDE_TOUR_KEY = 'searchIndicesIngestDataGuideTour';
const useGuideTour = () => {
  const hasDismissedGuide = localStorage.getItem(GUIDE_TOUR_KEY) === 'dismissed';
  const [tourIsOpen, setTourIsOpen] = (0, _react.useState)(!hasDismissedGuide);
  return {
    tourIsOpen,
    setTourIsOpen: isOpen => {
      setTourIsOpen(isOpen);
      localStorage.setItem(GUIDE_TOUR_KEY, isOpen ? '' : 'dismissed');
    }
  };
};
exports.useGuideTour = useGuideTour;