"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AISearchQuickStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _setup_ai_search_button = require("./setup_ai_search_button");
var _quick_stat = require("./quick_stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/ai_search_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AISearchQuickStat = ({
  mappingStats,
  vectorFieldCount,
  open,
  setOpen
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "sparkles",
    iconColor: euiTheme.colors.fullShade,
    title: _i18n.i18n.translate('xpack.searchIndices.quickStats.ai_search_heading', {
      defaultMessage: 'AI Search'
    }),
    "data-test-subj": "QuickStatsAIMappings",
    secondaryTitle: vectorFieldCount > 0 ? _i18n.i18n.translate('xpack.searchIndices.quickStats.total_count', {
      defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
      values: {
        value: vectorFieldCount
      }
    }) : _i18n.i18n.translate('xpack.searchIndices.quickStats.no_vector_fields', {
      defaultMessage: 'Not configured'
    }),
    content: vectorFieldCount === 0 ? /*#__PURE__*/_react.default.createElement(_setup_ai_search_button.SetupAISearchButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 41
      }
    }) : undefined,
    stats: [{
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.sparse_vector', {
        defaultMessage: 'Sparse Vector'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.sparse_vector_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.sparse_vector
        }
      })
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.dense_vector', {
        defaultMessage: 'Dense Vector'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.dense_vector_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.dense_vector
        }
      })
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.semantic_text', {
        defaultMessage: 'Semantic Text'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.semantic_text_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.semantic_text
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.AISearchQuickStat = AISearchQuickStat;