"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDetailsPageMenuItemPopover = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_indices/public/components/indices/details_page_menu_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIndexDetailsPageMenuItemPopover = ({
  showApiReference = false,
  handleDeleteIndexModal,
  userPrivileges
}) => {
  const [showMoreOptions, setShowMoreOptions] = (0, _react.useState)(false);
  const {
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const canManageIndex = (0, _react.useMemo)(() => {
    return (userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex) === true;
  }, [userPrivileges]);
  const contextMenuItems = [showApiReference && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "apiReference",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 15
      }
    }),
    href: docLinks.links.apiReference,
    size: "s",
    target: "_blank",
    "data-test-subj": "moreOptionsApiReference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.moreOptions.apiReferenceLabel",
    defaultMessage: "API Reference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "deleteIndex",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: canManageIndex ? 'danger' : undefined,
      type: "trash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }),
    size: "s",
    onClick: handleDeleteIndexModal,
    "data-test-subj": "moreOptionsDeleteIndex",
    toolTipContent: !canManageIndex ? _i18n.i18n.translate('xpack.searchIndices.moreOptions.deleteIndex.permissionToolTip', {
      defaultMessage: 'You do not have permission to delete an index'
    }) : undefined,
    toolTipProps: {
      'data-test-subj': 'moreOptionsDeleteIndexTooltip'
    },
    disabled: !canManageIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: canManageIndex ? 'danger' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.moreOptions.deleteIndexLabel",
    defaultMessage: "Delete Index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })))].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showMoreOptions,
    closePopover: () => setShowMoreOptions(!showMoreOptions),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      onClick: () => setShowMoreOptions(!showMoreOptions),
      size: "m",
      "data-test-subj": "moreOptionsActionButton",
      "aria-label": _i18n.i18n.translate('xpack.searchIndices.moreOptions.ariaLabel', {
        defaultMessage: 'More options'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "moreOptionsContextMenu",
    items: contextMenuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.SearchIndexDetailsPageMenuItemPopover = SearchIndexDetailsPageMenuItemPopover;