"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiveDeeperWithElasticsearch = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../common/doc_links");
var _doc_callouts = require("./doc_callouts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/dive_deeper/dive_deeper_with_elasticsearch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DiveDeeperWithElasticsearch = () => {
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: currentBreakpoint === 'xl' ? 'row' : 'column',
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "searchLabsSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.title', {
      defaultMessage: 'Elasticsearch Labs'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.description', {
      defaultMessage: 'Explore the latest innovations for advanced search experiences.'
    }),
    buttonHref: _doc_links.docLinks.visitSearchLabs,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.buttonText', {
      defaultMessage: 'Visit Elasticsearch Labs'
    }),
    dataTestSubj: "searchLabsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "pythonNotebooksSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.title', {
      defaultMessage: 'Python notebooks'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.description', {
      defaultMessage: 'Test features in a virtual environment with executable notebooks.'
    }),
    buttonHref: _doc_links.docLinks.notebooksExamples,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.buttonText', {
      defaultMessage: 'Open notebooks'
    }),
    dataTestSubj: "openNotebooksButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "elasticsearchDocumentationSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocs.title', {
      defaultMessage: 'Elasticsearch documentation'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocumentation.description', {
      defaultMessage: 'Learn about Elasticsearch APIs, query languages, and common use cases.'
    }),
    buttonHref: _doc_links.docLinks.elasticsearchDocs,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocumentation.buttonText', {
      defaultMessage: 'View documentation'
    }),
    dataTestSubj: "viewDocumentationButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })));
};
exports.DiveDeeperWithElasticsearch = DiveDeeperWithElasticsearch;