"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAPIKeyById = getAPIKeyById;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAPIKeyById(id, client, logger) {
  try {
    var _apiKey$api_keys;
    const apiKey = await client.security.getApiKey({
      id
    });
    return (_apiKey$api_keys = apiKey.api_keys) === null || _apiKey$api_keys === void 0 ? void 0 : _apiKey$api_keys[0];
  } catch (e) {
    logger.error(`Search API Keys: Error on getting API Key`);
    logger.error(e);
    throw e;
  }
}