"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEMA_SEARCH_V8_8_0 = exports.SCHEMA_SEARCH_MODEL_VERSION_9_SO_API_WORKAROUND = exports.SCHEMA_SEARCH_MODEL_VERSION_8 = exports.SCHEMA_SEARCH_MODEL_VERSION_7 = exports.SCHEMA_SEARCH_MODEL_VERSION_6 = exports.SCHEMA_SEARCH_MODEL_VERSION_5 = exports.SCHEMA_SEARCH_MODEL_VERSION_4 = exports.SCHEMA_SEARCH_MODEL_VERSION_3 = exports.SCHEMA_SEARCH_MODEL_VERSION_2 = exports.SCHEMA_SEARCH_MODEL_VERSION_1 = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SCHEMA_SEARCH_BASE = _configSchema.schema.object({
  // General
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string({
    defaultValue: ''
  }),
  // Data grid
  columns: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  sort: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 2
  })), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 2
  })], {
    defaultValue: []
  }),
  grid: _configSchema.schema.object({
    columns: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      width: _configSchema.schema.maybe(_configSchema.schema.number())
    })))
  }, {
    defaultValue: {}
  }),
  rowHeight: _configSchema.schema.maybe(_configSchema.schema.number()),
  rowsPerPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  // Chart
  hideChart: _configSchema.schema.boolean({
    defaultValue: false
  }),
  breakdownField: _configSchema.schema.maybe(_configSchema.schema.string()),
  // Search
  kibanaSavedObjectMeta: _configSchema.schema.object({
    searchSourceJSON: _configSchema.schema.string()
  }),
  isTextBasedQuery: _configSchema.schema.boolean({
    defaultValue: false
  }),
  usesAdHocDataView: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // Time
  timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeRange: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.string(),
    to: _configSchema.schema.string()
  })),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    pause: _configSchema.schema.boolean(),
    value: _configSchema.schema.number()
  })),
  // Display
  viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.VIEW_MODE.DOCUMENT_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.AGGREGATED_LEVEL)])),
  hideAggregatedPreview: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // Legacy
  hits: _configSchema.schema.maybe(_configSchema.schema.number()),
  version: _configSchema.schema.maybe(_configSchema.schema.number())
});
const SCHEMA_SEARCH_V8_8_0 = exports.SCHEMA_SEARCH_V8_8_0 = SCHEMA_SEARCH_BASE;
const SCHEMA_SEARCH_MODEL_VERSION_1 = exports.SCHEMA_SEARCH_MODEL_VERSION_1 = SCHEMA_SEARCH_BASE.extends({
  sampleSize: _configSchema.schema.maybe(_configSchema.schema.number({
    min: _common.MIN_SAVED_SEARCH_SAMPLE_SIZE,
    max: _common.MAX_SAVED_SEARCH_SAMPLE_SIZE
  }))
});
const SCHEMA_SEARCH_MODEL_VERSION_2 = exports.SCHEMA_SEARCH_MODEL_VERSION_2 = SCHEMA_SEARCH_MODEL_VERSION_1.extends({
  headerRowHeight: _configSchema.schema.maybe(_configSchema.schema.number())
});
const SCHEMA_SEARCH_MODEL_VERSION_3 = exports.SCHEMA_SEARCH_MODEL_VERSION_3 = SCHEMA_SEARCH_MODEL_VERSION_2.extends({
  visContext: _configSchema.schema.maybe(_configSchema.schema.oneOf([
  // existing value
  _configSchema.schema.object({
    // unified histogram state
    suggestionType: _configSchema.schema.string(),
    requestData: _configSchema.schema.object({
      dataViewId: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeField: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeInterval: _configSchema.schema.maybe(_configSchema.schema.string()),
      breakdownField: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    // lens attributes
    attributes: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  }),
  // cleared previous value
  _configSchema.schema.object({})]))
});
const SCHEMA_SEARCH_MODEL_VERSION_4 = exports.SCHEMA_SEARCH_MODEL_VERSION_4 = SCHEMA_SEARCH_MODEL_VERSION_3.extends({
  viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.VIEW_MODE.DOCUMENT_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.PATTERN_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.AGGREGATED_LEVEL)]))
});
const SCHEMA_SEARCH_MODEL_VERSION_5 = exports.SCHEMA_SEARCH_MODEL_VERSION_5 = SCHEMA_SEARCH_MODEL_VERSION_4.extends({
  density: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('compact'), _configSchema.schema.literal('normal'), _configSchema.schema.literal('expanded')]))
});
const DISCOVER_SESSION_TAB_ATTRIBUTES = SCHEMA_SEARCH_MODEL_VERSION_5.extends({
  title: undefined,
  description: undefined
});
const SCHEMA_DISCOVER_SESSION_TAB = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  label: _configSchema.schema.string(),
  // Remove `title` and `description` from the tab schema as they exist at the top level of the saved object
  attributes: DISCOVER_SESSION_TAB_ATTRIBUTES
});
const SCHEMA_SEARCH_MODEL_VERSION_6 = exports.SCHEMA_SEARCH_MODEL_VERSION_6 = SCHEMA_SEARCH_MODEL_VERSION_5.extends({
  tabs: _configSchema.schema.maybe(_configSchema.schema.arrayOf(SCHEMA_DISCOVER_SESSION_TAB, {
    minSize: 1
  }))
});
const {
  columns,
  grid,
  hideChart,
  isTextBasedQuery,
  kibanaSavedObjectMeta,
  rowHeight,
  sort
} = SCHEMA_SEARCH_MODEL_VERSION_6.getPropSchemas();

// Mark top-level attributes (except title and description) optional, and mark tabs as required
const SCHEMA_SEARCH_MODEL_VERSION_7 = exports.SCHEMA_SEARCH_MODEL_VERSION_7 = SCHEMA_SEARCH_MODEL_VERSION_6.extends({
  columns: _configSchema.schema.maybe(columns),
  grid: _configSchema.schema.maybe(grid),
  hideChart: _configSchema.schema.maybe(hideChart),
  isTextBasedQuery: _configSchema.schema.maybe(isTextBasedQuery),
  kibanaSavedObjectMeta: _configSchema.schema.maybe(kibanaSavedObjectMeta),
  rowHeight: _configSchema.schema.maybe(rowHeight),
  sort: _configSchema.schema.maybe(sort),
  tabs: _configSchema.schema.arrayOf(SCHEMA_DISCOVER_SESSION_TAB, {
    minSize: 1
  })
});
const CONTROL_GROUP_JSON_SCHEMA = {
  controlGroupJson: _configSchema.schema.maybe(_configSchema.schema.string())
};
const DISCOVER_SESSION_TAB_ATTRIBUTES_VERSION_8 = DISCOVER_SESSION_TAB_ATTRIBUTES.extends(CONTROL_GROUP_JSON_SCHEMA);
const SCHEMA_DISCOVER_SESSION_TAB_VERSION_8 = SCHEMA_DISCOVER_SESSION_TAB.extends({
  attributes: DISCOVER_SESSION_TAB_ATTRIBUTES_VERSION_8
});
const SCHEMA_SEARCH_MODEL_VERSION_8 = exports.SCHEMA_SEARCH_MODEL_VERSION_8 = SCHEMA_SEARCH_MODEL_VERSION_7.extends({
  ...CONTROL_GROUP_JSON_SCHEMA,
  tabs: _configSchema.schema.arrayOf(SCHEMA_DISCOVER_SESSION_TAB_VERSION_8, {
    minSize: 1
  })
});

// We need to flatten the schema type here to avoid this error:
// "Type instantiation is excessively deep and possibly infinite",
// since each `extends()` call wraps the previous type until we hit the depth limit.
const {
  tabs: tabsV8,
  ...restV8Props
} = SCHEMA_SEARCH_MODEL_VERSION_8.getPropSchemas();

// This schema temporarily makes `tabs` optional again, to work around an issue
// where saved objects created via the deprecated saved objects API without a
// specified version would fail validation if `tabs` was not provided, which
// broke existing API usages after SCHEMA_SEARCH_MODEL_VERSION_8 was added.
// It should not be relied on in application code or used for the content
// management validation schema, and `tabs` should be required again once Core
// provides a way to fix the underlying issue at the saved objects API level.
const SCHEMA_SEARCH_MODEL_VERSION_9_SO_API_WORKAROUND = exports.SCHEMA_SEARCH_MODEL_VERSION_9_SO_API_WORKAROUND = _configSchema.schema.object({
  ...restV8Props,
  tabs: _configSchema.schema.maybe(tabsV8)
});